<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Student Fee Invoice
<?php endsection() ?>
<?php section('content') ?>
<!-- <style>
@media only print {
  body { visibility: hidden; }
  #content { visibility: visible; }
}
</style> -->
<div class="row">
    <div class="col-md-12">
        <div class="ibox invoice px-5">
        	<div id="print-content">
            <div class="invoice-header">
                <div class="row">
                    <div class="col-6">
                        <div class="invoice-logo">
                            <img src="/img/logos/logo-vue.png" height="65px" />
                        </div>
                    </div>
                    <div class="col-6 text-right">
                        <div class="clf" style="margin-bottom:30px;">
                            <dl class="row pull-right" style="width:250px;">
                            	<dt class="col-sm-6">Invoice No</dt><dd class="col-sm-6">#<?= mt_rand(1000, 9999) ?></dd>
                                <dt class="col-sm-6">Issue Date</dt><dd class="col-sm-6"><?= date("d M Y") ?></dd>
                                <!-- <dt class="col-sm-6">Status</dt><dd class="col-sm-6"><span class="badge badge-danger">Pending</span></dd> -->
                            </dl>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-6">
                        <div>
                            <div class="m-b-5 font-bold">Invoice from</div>
                            <div>Smart College</div>
                            <ul class="list-unstyled m-t-10">
                                <li class="m-b-5">Curve, Oyigbo, Rivers State</li>
                                <li class="m-b-5">support@smart-college.co</li>
                                <li>+234-0813-580-5584</li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-6 text-right">
                        <div>
                            <div class="m-b-5 font-bold">Invoice To</div>
                            <div><?= esc($student) ?></div>
                            <ul class="list-unstyled m-t-10">
                                <li class="m-b-5"><?= esc($student->address) ?></li>
                                <li class="m-b-5"><?= esc($student->email) ?></li>
                                <li><?= esc($student->phone) ?></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <!-- <div class="m-b-20">
            	<button class="btn btn-default m-r-10" data-toggle="modal" data-target="#fee-collect-one" >
            		<i class="fa fa-credit-card"></i> Collect One
            	</button>
            	<button class="btn btn-default" data-toggle="modal" data-target="#fee-collect-all" >
            		<i class="fa fa-credit-card"></i> Collect All
            	</button>
            </div> -->
            <table class="table table-hover no-margin table-invoice">
                <thead>
                    <tr>
                        <th>Fee Type</th>
                        <th>Amount(₦)</th>
                        <th>Due Date</th>
                        <!-- <th>Discount</th> -->
                        <th>Paid(₦)</th>
                        <th>Status</th>
                        <th class="text-right">Balance(₦)</th>
                    </tr>
                </thead>
                <tbody>
                	<?php $grand_total = 0 ?>
                	<?php foreach ($fees as $fee): ?>
                		<tr class="bg-grey-50 font-strong">
                			<th><?= esc($fee->fee_group->fee_type) ?> <i class="fa fa-chevron-down"></i></th>
                            <td><?= esc($fee->amount) ?></td>
                            <td><?= esc($fee->fee_group->due_date) ?></td>
                            <!-- <td><?//= esc($fee->fee_discount) ?></td> -->
                            <td><?= esc($fee->paid) ?></td>
                            <td>
                            	<?php if ($fee->status == 'pending'): ?>
                    				<span class="badge badge-danger"><?= ucfirst(esc($fee->status)) ?></span>
                    			<?php elseif ($fee->status == 'part'): ?>
                    				<span class="badge badge-warning"><?= ucfirst(esc($fee->status)) ?></span>
                    			<?php elseif ($fee->status == 'paid'): ?>
                    				<span class="badge badge-success"><?= ucfirst(esc($fee->status)) ?></span>
                    			<?php endif ?>
                            </td>
                            <td><?= esc($fee->balance) ?></td>
                		</tr>
                		<?php 
                			$fee_details = $fee->fee_group->fee_details->all() ; 
                			$fee_details_total = $fee->fee_group->fee_details->sum('amount');
                			$grand_total += $fee_details_total;
                		 ?>
                		<?php foreach ($fee_details as $fdetail): ?>
                		<tr>
                            <td><div><strong><?= esc($fdetail->name) ?></strong></div></td>
                            <td><?= esc($fdetail->amount) ?></td>
                        </tr>
                        <?php endforeach ?>
                	<?php endforeach ?>
                </tbody>
            </table>
            <table class="table no-border">
                <thead>
                    <tr>
                        <th></th>
                        <th width="15%"></th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="text-right">
                        <td>Paid:</td>
                        <td>₦<?= esc($paid) ?></td>
                    </tr>
                    <tr class="text-right">
                        <td>Balance:</td>
                        <td>₦<?= esc($balance) ?></td>
                    </tr>
                    <tr class="text-right">
                        <td class="font-bold font-18">Grand Total:</td>
                        <td class="font-bold font-18">₦<?= esc($grand_total) ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
            <div>
            	<div class="text-left">
            		<button class="btn btn-default m-r-10" data-toggle="modal" data-target="#fee-collect-one" >
	            		<i class="fa fa-credit-card"></i> Collect One
	            	</button>
	            	<button class="btn btn-default" data-toggle="modal" data-target="#fee-collect-all" >
	            		<i class="fa fa-credit-card"></i> Collect All
	            	</button>
            	</div>
	            <div class="text-right">
	                <a class="btn btn-info" href="<?= esc(route('fee.pdf', [$student->id])) ?>"><i class="fa fa-file-pdf-o"></i> PDF</a>
	                <button class="btn btn-info" type="button" onclick="printpage('print-content')"><i class="fa fa-print"></i> Print</button>
	                <button class="btn btn-info" type="button" onclick="printH2P('print-content')"><i class="fa fa-print"></i> PrintPDF</button>
	            </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="fee-collect-one" data-backdrop="static" tabindex="-1" aria-hidden="true">
  	<div class="modal-dialog">
	    <div class="modal-content rounded">
	      	<div class="modal-header">
		        <h4 class="modal-title"><i class="fa fa-credit-card"></i> Collect Fee</h4>
		        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
	      	</div>
	      	<div class="modal-body">
		        <form action="<?= esc(route('fee.collect.save', [$student->id])) ?>" method="POST" class="create-form">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Fee Group<span class="text-danger">*</span></label>
                                <select name="fee_group" class="form-control custom-select">
                                    <option value="" selected="">Select</option>
                                    <?php foreach ($fees as $fee): ?>
                                    <option value="<?= esc($fee->fee_group->id) ?>"><?= esc($fee->fee_group->fee_type) ?></option>
			                        <?php endforeach ?>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12 kn">
                            <div class="form-group">
                                <label>Amount<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="paid">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <!-- <div class="col-md-12">
                            <div class="form-group">
                                <label>Discount</label>
                                <select name="discount" class="form-control custom-select">
                                    <option value="" selected="">Select</option>
                                    <?php // foreach ($fee_discounts as $discount): ?>
                                    <option value="<?//= esc($discount->id) ?>"><?//= esc($discount) ?></option>
			                        <?php // endforeach ?>
                                </select>
                            </div>
                        </div> -->
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Payment Method<span class="text-danger">*</span></label>
                                <select name="payment_mode" class="form-control custom-select">
                                    <option value="" selected="">Select</option>
                                    <?php foreach ($payment_modes as $mode): ?>
                                    <option value="<?= esc($mode->id) ?>"><?= esc($mode) ?></option>
			                        <?php endforeach ?>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12 kn">
                            <div class="form-group">
                                <label>Date<span class="text-danger">*</span></label>
                                <input class="form-control" type="date" name="date">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Remark</label>
                                <textarea class="form-control" name="remark"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                    	<button class="btn btn-default rounded mr-3" data-dismiss="modal">Cancel</button>
                        <button class="btn btn-primary rounded" type="submit">Collect</button>
                    </div>
                </form>
	      	</div>
	    </div>
  	</div>
</div>
<div class="modal fade" id="fee-collect-all" data-backdrop="static" tabindex="-1" aria-hidden="true">
  	<div class="modal-dialog">
	    <div class="modal-content rounded">
	      	<div class="modal-header">
		        <h4 class="modal-title"><i class="fa fa-credit-card"></i> Collect Fees</h4>
		        <button type="button" class="btn btn-outline-default btn-sm btn-circle" data-dismiss="modal"><i class="fa fa-times"></i></button>
	      	</div>
	      	<div class="modal-body">
		        <form action="<?= esc(route('fees.collect.save')) ?>" method="POST" class="create-form">
		        	<input type="hidden" name="fees" value="<?php foreach ($fees as $fee): ?><?= esc($fee->id) ?>,<?php endforeach ?>">
                    <div class="row">
                        <div class="col-md-12 kn">
                            <div class="form-group">
                                <label>Amount<span class="text-danger">*</span></label>
                                <input class="form-control" type="text" name="amount" value="<?= esc($grand_total) ?>" readonly>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Payment Method<span class="text-danger">*</span></label>
                                <select name="payment_mode" class="form-control custom-select">
                                    <option value="" selected="">Select</option>
                                    <?php foreach ($payment_modes as $mode): ?>
                                    <option value="<?= esc($mode->id) ?>"><?= esc($mode) ?></option>
			                        <?php endforeach ?>
                                </select>
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12 kn">
                            <div class="form-group">
                                <label>Date<span class="text-danger">*</span></label>
                                <input class="form-control" type="date" name="date">
                                <div class="invalid-feedback"></div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label>Remark</label>
                                <textarea class="form-control" name="remark"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                    	<button class="btn btn-default rounded mr-3" data-dismiss="modal">Cancel</button>
                        <button class="btn btn-primary rounded" type="submit">Collect</button>
                    </div>
                </form>
	      	</div>
	    </div>
  	</div>
</div>
<?php endsection() ?>