<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Student Fee Allocation
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
    <div class="col-md-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title"><i class="fa fa-search"></i> Search Criteria</div>
            </div>
            <div class="ibox-body" id="fee-allocation-filter">
                <form action="<?= esc(route('fee.allocation')) ?>" method="GET">
                    <div class="row">
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Class<span class="text-danger">*</span></label>
                                        <select name="klass" data-url="<?= esc(route('section.select')) ?>?klass_id=" class="form-control custom-select klass-field">
                                            <?php if (! empty($currentklass)): ?>
                                                <option value="<?= esc($currentklass->id) ?>"><?= esc($currentklass->name) ?></option>
                                            <?php endif ?>
                                            <option value="">Select</option>
                                            <?php foreach ($klasses as $klass): ?>
                                                <option value="<?= esc($klass->id) ?>"><?= esc($klass->name) ?></option>
                                            <?php endforeach ?>
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Section<span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <select name="section" class="form-control custom-select ksection">
                                            <?php if (! empty($currentsection)): ?>
                                                <option value="<?= esc($currentsection->id) ?>"><?= esc($currentsection->name) ?></option>
                                            <?php endif ?>
                                                <option value="">Select Class First</option>
                                            </select>
                                            <div class="invalid-feedback"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Fee Group<span class="text-danger">*</span></label>
                                        <select name="feegroup" class="form-control custom-select">
                                            <?php if (! empty($currentfeegroup)): ?>
                                                <option value="<?= esc($currentfeegroup->id) ?>"><?= esc($currentfeegroup->fee_type) ?></option>
                                            <?php endif ?>
                                            <option value="">Select</option>
                                            <?php foreach ($feegroups as $feegroup): ?>
                                                <option value="<?= esc($feegroup->id) ?>"><?= esc($feegroup->fee_type) ?></option>
                                            <?php endforeach ?>
                                        </select>
                                        <div class="invalid-feedback"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group pb-4">
                                <label>&nbsp;</label>
                                <button class="btn btn-primary rounded form-control px-5" type="submit" id="allocate-fee-btn">
                                    <i class="fa fa-filter"></i>&nbsp;Filter
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php if (! empty($getklass) && ! empty($getsection) && ! empty($getfeegroup)): ?>
<div class="row">
    <div class="col-md-12">
        <form action="<?= esc(route('fee.allocation.save')) ?>" method="POST" id="fee-allocation-form" class="allocation-form">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title"><i class="fa fa-money"></i> Student Fee Allocation</div>
                    <div class="ibox-tools">
                        <button class="btn btn-primary" type="submit" id="save-fee-allocation">
                            <i class="fa fa-cart-plus"></i>&nbsp;Allocate
                        </button>
                    </div>
                </div>
                <div class="ibox-body">
                    <div class="row mb-2">
                        <div class="col-md-6">
                            <div class="alert alert-info alert-bordered">
                                <div>Please check the students you want to assign the fee group.</div>
                            </div>
                        </div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-md-12">
                            <span class="badge badge-info m-r-5 m-b-5"><?= esc($currentklass) ?></span>
                            <span class="badge badge-info m-r-5 m-b-5">Section <?= esc($currentsection) ?></span>
                            <span class="badge badge-info m-r-5 m-b-5"><?= esc($currentfeegroup->fee_type) ?></span>
                        </div>
                    </div>
                    <table class="table table-bordered table-hover data-table" id="table" cellspacing="0" width="100%" >
                        <thead class="thead-light">
                            <tr>
                                <th>Student Photo</th>
                                <th>Student Name</th>
                                <th>Reg Number</th>
                                <th>Roll Number</th>
                                <!-- <th>Outstanding Fee</th> -->
                                <th>Gender</th>
                                <th> 
                                    <label class="ui-checkbox ui-checkbox-success">
                                        <input type="checkbox" name="check_all" id="check-all">
                                        <span class="input-span"></span> <b>Assign All</b>
                                    </label>
                                </th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="check-table">
                            <?php $fee_amount = $currentfeegroup->fee_details->sum('amount') ?>
                            <?php foreach ($students as $student): ?>
                            <tr class="table-row">
                                <td><img src="<?= esc(source('image.student', $student->photo)) ?>" alt="student photo" style="height: 30px;"></td>
                                <td>
                                    <?= esc($student) ?>
                                    <input type="hidden" class="student" value="<?= esc($student->id) ?>" name="student<?= esc(counter()) ?>">
                                </td>
                                <td><?= esc($student->reg_num) ?></td>
                                <td>
                                	<?= esc($student->roll_num) ?>
                                    <input type="hidden" name="session<?= esc(counter()) ?>" class="session" value="<?= esc($getsession->id) ?>">
                                    <input type="hidden" name="term<?= esc(counter()) ?>" class="term" value="<?= esc($getterm->id) ?>">
                                </td>
                            	<input type="hidden" name="fee_group<?= esc(counter()) ?>" class="fee_group" value="<?= esc($currentfeegroup->id) ?>">
                                <input type="hidden" name="amount<?= esc(counter()) ?>" class="amount" value="<?= esc($fee_amount) ?>">
                                <input type="hidden" name="balance<?= esc(counter()) ?>" class="balance" value="<?= esc($fee_amount) ?>">
                                <td><?= esc($student->gender) ?></td>
                                <td>
                                    <label class="ui-checkbox ui-checkbox-success">
                                    	<?php 
                                    		$assigned = $student->fee_collections->filter([
                                    			'fee_group' => $currentfeegroup, 'and',
                                    			'session' => $getsession, 'and',
                                    			'term' => $getterm
                                    		])->exists() 
                                    	?>
                                        <input type="checkbox" name="row_check<?= esc(counter()) ?>" class="row-check" <?php if ($assigned): ?>checked<?php endif ?>>
                                        <span class="input-span"></span> 
                                    </label>
                                </td>
                                <td>
                                    <a href="<?= esc(route('student.profile', ['id' => $student->id])) ?>" class="btn btn-default btn-xs m-r-5" title="View">
                                        <i class="fa fa-bars font-14"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </form>
    </div>
</div>
<?php endif ?>
<?php endsection() ?>