<?php extend_layout('admin/layouts/base') ?>
<?php section('csrf-meta') ?>
<?= csrf_header() ?>
<?php endsection() ?>
<?php section('title') ?>
Expense Edit
<?php endsection() ?>
<?php section('content') ?>
<div class="row">
	<div class="col-md-12">
		<div class="ibox" id="expense-ibox">
            <div class="ibox-head">
                <ul class="nav nav-tabs tabs-line">
                    <li class="nav-item">
                        <a class="nav-link" href="<?= esc(route('expense.index')) ?>"><i class="fa fa-list"></i> Expense List</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#edit" data-toggle="tab"><i class="fa fa-edit"></i> Edit Expense</a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body dt-show" id="expense-form">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="edit">
		                <form action="<?= esc(route('expense.update', [$expense->id])) ?>?_method=PUT" method="POST" class="save-edit-form">
		                    <div class="row">
		                    	<div class="col-md-6">
		                            <div class="form-group">
		                                <label>Head<span class="text-danger">*</span></label>
		                                <select name="head" class="form-control custom-select">
		                                	<option value="<?= esc($expense->head->id) ?>" selected><?= esc($expense->head) ?></option>
		                                	<?php foreach ($heads as $head): ?>
		                                		<option value="<?= esc($head->id) ?>"><?= esc($head) ?></option>
		                                	<?php endforeach ?>
		                                </select>
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Title<span class="text-danger">*</span></label>
		                                <input class="form-control" type="text" name="title" value="<?= esc($expense->title) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                    	<div class="col-md-4">
		                            <div class="form-group">
		                                <label>Ref Number</label>
		                                <input class="form-control" type="text" name="ref_num" value="<?= esc($expense->ref_num) ?>">
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Amount<span class="text-danger">*</span></label>
	                                    <input class="form-control" type="text" name="amount" value="<?= esc($expense->amount) ?>">
		                                <div class="invalid-feedback"></div>
		                            </div>
		                        </div>
		                        <div class="col-md-4">
		                            <div class="form-group">
		                                <label>Paid Via</label>
		                                <select class="form-control custom-select" name="paid_via">
		                                	<option value="<?= esc($expense->paid_via) ?>"><?= esc($expense->paid_via) ?></option>
		                                	<option value="">Select</option>
		                                	<option value="Cash">Cash</option>
		                                	<option value="Card">Card</option>
		                                	<option value="Cheque">Cheque</option>
		                                	<option value="Bank">Bank</option>
		                                	<option value="POS">POS</option>
		                                </select>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Date</label>
		                                <input name="date" class="form-control" type="date" value="<?= esc($expense->date) ?>">
		                            </div>
		                        </div>
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Attachment</label>
	                                    <input class="dropify" type="file" name="attachment" data-height="20" data-max-file-size="2M" data-default-file="<?= esc(source('file.expense', $expense->attachment)) ?>">
		                            </div>
		                        </div>
		                    </div>
		                    <div class="row">
		                        <div class="col-md-6">
		                            <div class="form-group">
		                                <label>Description</label>
		                                <textarea class="form-control" name="description"><?= esc($expense->description) ?></textarea>
		                            </div>
		                        </div>
		                    </div>
		                    <div class="form-group">
		                        <button class="btn btn-primary rounded" type="submit">Submit</button>
		                    </div>
		                </form>
                    </div>
                </div>
            </div>
        </div>
	</div>
</div>
<?php endsection() ?>