<?php 

use App\Controllers\UserController;
use App\Controllers\FileController;
use App\Controllers\HomeController;
use App\Controllers\StaffController;
use App\Controllers\ReportController;
use App\Controllers\ProductController;
use App\Controllers\PurchaseController;
use App\Controllers\SettingsController;
use App\Controllers\MaterialController;
use App\Controllers\InventoryController;
use App\Controllers\AccountingController;
use App\Controllers\InformationController;
use App\Controllers\CommunicationController;

$route = app('route');
 //
$route->group(['prefix' => '/admin', 'middlewares' => ['forbidden', 'auth_required']], function ($route) {
	$route->add('/', [HomeController::class, 'index'], ['name' => 'admin.index']);

	/**
	 * HUMAN RESOURCES MODULE
	*/
	$route->add('/department/index', [StaffController::class, 'department'], ['name' => 'department.index',]);
	$route->add('/department/create', [StaffController::class, 'createDepartment'], [
		'name' => 'department.create',
		'methods' => 'POST',
	]);
	$route->add('/department/update/{id:int}', [StaffController::class, 'updateDepartment'], [
		'name' => 'department.update',
		'methods' => 'PUT',
	]);
	$route->add('/department/delete/{id:int}', [StaffController::class, 'deleteDepartment'], [
		'name' => 'department.delete',
		'methods' => 'DELETE',
	]);

	$route->add('/designation/index', [StaffController::class, 'designation'], ['name' => 'designation.index',]);
	$route->add('/designation/create', [StaffController::class, 'createDesignation'], [
		'name' => 'designation.create',
		'methods' => 'POST',
	]);
	$route->add('/designation/update/{id:int}', [StaffController::class, 'updateDesignation'], [
		'name' => 'designation.update',
		'methods' => 'PUT',
	]);
	$route->add('/designation/delete/{id:int}', [StaffController::class, 'deleteDesignation'], [
		'name' => 'designation.delete',
		'methods' => 'DELETE',
	]);

	$route->add('/social/index', [StaffController::class, 'social'], ['name' => 'social.index',]);
	$route->add('/social/create', [StaffController::class, 'createSocial'], [
		'name' => 'social.create',
		'methods' => 'POST',
	]);
	$route->add('/social/update/{id:int}', [StaffController::class, 'updateSocial'], [
		'name' => 'social.update',
		'methods' => 'PUT',
	]);
	$route->add('/social/delete/{id:int}', [StaffController::class, 'deleteSocial'], [
		'name' => 'social.delete',
		'methods' => 'DELETE',
	]);

	$route->add('/staff/index', [StaffController::class, 'index'], ['name' => 'staff.index',]);
	$route->add('/staff/add', [StaffController::class, 'add'], ['name' => 'staff.add',]);
	$route->add('/staff/create', [StaffController::class, 'create'], [
		'name' => 'staff.create',
		'methods' => 'POST',
	]);
	$route->add('/staff/edit/{id:int}', [StaffController::class, 'edit'], ['name' => 'staff.edit',]);
	$route->add('/staff/update/{id:int}', [StaffController::class, 'update'], [
		'name' => 'staff.update',
		'methods' => 'PUT',
	]);
	$route->add('/staff/profile/{id:int}', [StaffController::class, 'profile'], ['name' => 'staff_profile.detail',]);
	$route->add('/staff/delete/{id:int}', [StaffController::class, 'delete'], [
		'name' => 'staff.delete',
		'methods' => 'DELETE',
	]);
	// Staff Document
	$route->add('/staff-documents/create/{id:int}', [StaffController::class, 'createDocument'], [
		'name' => 'staff_document.create',
		'methods' => 'POST',
	]);
	$route->add('/staff-documents/update/{id:int}', [StaffController::class, 'updateDocument'], [
		'name' => 'staff_document.update',
		'methods' => 'PUT',
	]);
	$route->add('/staff-documents/delete/{id:int}', [StaffController::class, 'deleteDocument'], [
		'name' => 'staff_document.delete',
		'methods' => 'DELETE',
	]);
	// Staff Social Handle 
	$route->add('/staff-social-handle/create', [StaffController::class, 'createHandle'], [
		'name' => 'staff_social.create',
		'methods' => 'POST',
	]);
	$route->add('/staff-social-handle/update/{id:int}', [StaffController::class, 'updateHandle'], [
		'name' => 'staff_social.update',
		'methods' => 'PUT',
	]);
	$route->add('/staff-social-handle/delete/{id:int}', [StaffController::class, 'deleteHandle'], [
		'name' => 'staff_social.delete',
		'methods' => 'DELETE',
	]);
	// Staff Attendance
	$route->add('/staff-attendance/index', [StaffController::class, 'attendance'], ['name' => 'staff_attendance.index',]);
	$route->add('/staff-attendance/save', [StaffController::class, 'saveAttendance'], [
		'name' => 'staff_attendance.create',
		'methods' => 'POST',
	]);
	// Staff Salary
	$route->add('/salary/index', [StaffController::class, 'salary'], ['name' => 'salary.index',]);
	$route->add('/salary/create', [StaffController::class, 'createSalary'], [
		'name' => 'salary.create',
		'methods' => 'POST',
	]);
	$route->add('/salary/edit/{id:int}', [StaffController::class, 'editSalary'], ['name' => 'salary.edit',]);
	$route->add('/salary/update/{id:int}', [StaffController::class, 'updateSalary'], [
		'name' => 'salary.update',
		'methods' => 'PUT',
	]);
	$route->add('/salary/delete/{id:int}', [StaffController::class, 'deleteSalary'], [
		'name' => 'salary.delete',
		'methods' => 'DELETE',
	]);

	$route->add('/leave-type/index', [StaffController::class, 'leaveType'], ['name' => 'leave_type.index',]);
	$route->add('/leave-type/create', [StaffController::class, 'createLeaveType'], [
		'name' => 'leave_type.create',
		'methods' => 'POST',
	]);
	$route->add('/leave-type/update/{id:int}', [StaffController::class, 'updateLeaveType'], [
		'name' => 'leave_type.update',
		'methods' => 'PUT',
	]);
	$route->add('/leave-type/delete/{id:int}', [StaffController::class, 'deleteLeaveType'], [
		'name' => 'leave_type.delete',
		'methods' => 'DELETE',
	]);

	$route->add('/leave/index', [StaffController::class, 'leave'], ['name' => 'leave.index',]);
	$route->add('/leave-apply/index', [StaffController::class, 'leaveApply'], ['name' => 'leave_apply.index',]);
	$route->add('/staff/select', [StaffController::class, 'selectStaff'], ['name' => 'staff.select',]);
	$route->add('/leave/create', [StaffController::class, 'createLeave'], [
		'name' => 'leave.create',
		'methods' => 'POST',
	]);
	$route->add('/leave/edit/{id:int}', [StaffController::class, 'leaveEdit'], ['name' => 'leave.edit',]);
	$route->add('/leave-apply/edit/{id:int}', [StaffController::class, 'leaveApplyEdit'], ['name' => 'leave_apply.edit',]);
	$route->add('/leave/update/{id:int}', [StaffController::class, 'updateLeave'], [
		'name' => 'leave_update',
		'methods' => 'PUT',
	]);
	$route->add('/leave/delete/{id:int}', [StaffController::class, 'deleteLeave'], [
		'name' => 'leave_delete',
		'methods' => 'DELETE',
	]);

	$route->add('/salary/allocate-salary', [StaffController::class, 'salaryAllocation'], ['name' => 'salary_allocation.index',]);
	$route->add('/salary/payroll', [StaffController::class, 'salaryPayroll'], ['name' => 'salary_payroll.index',]);
	// $route->add('/salary/payment/{id:int}/{month}', [StaffController::class, 'salaryPayment'], ['name' => 'salary.payment',]);
	$route->add('/salary/payslip/{id:int}/{month}', [StaffController::class, 'salaryPayslip'], ['name' => 'salary_payslip.index',]);
	$route->add('/salary/save-salary-allocation', [StaffController::class, 'saveSalaryAllocation'], [
		'name' => 'salary_allocation.create',
		'methods' => 'POST',
	]);
	$route->add('/salary/payment/{id:int}/{month}', [StaffController::class, 'salaryPayment'], [
		'name' => 'salary_payment.create',
		'methods' => ['GET', 'POST']
	]);

	$route->add('/logout', [UserController::class, 'logout'], ['name' => 'user.logout']);

	/**
	 * SETTINGS MODULE
	*/
	$route->add('/role/index', [SettingsController::class, 'role'], ['name' => 'role.index',]);
	$route->add('/role/create', [SettingsController::class, 'createRole'], [
		'name' => 'role.create',
		'methods' => 'POST',
	]);
	$route->add('/role/update/{id:int}', [SettingsController::class, 'updateRole'], [
		'name' => 'role.update',
		'methods' => 'PUT',
	]);
	$route->add('/role/delete/{id:int}', [SettingsController::class, 'deleteRole'], [
		'name' => 'role.delete',
		'methods' => 'DELETE',
	]);

	$route->add('/role-permission/{role:int}', [SettingsController::class, 'rolePermission'], ['name' => 'role_permission.index',]);
		$route->add('/role-permission/create', [SettingsController::class, 'createRolePermission'], [
		'name' => 'role_permission.create',
		'methods' => 'POST',
	]);

	$route->add('/payment-mode/index', [SettingsController::class, 'paymentMode'], ['name' => 'payment_mode.index',]);
	$route->add('/payment-mode/create', [SettingsController::class, 'createPaymentMode'], [
		'name' => 'payment_mode.create',
		'methods' => 'POST',
	]);
	$route->add('/payment-mode/update/{id:int}', [SettingsController::class, 'updatePaymentMode'], [
		'name' => 'payment_mode.update',
		'methods' => 'PUT',
	]);
	$route->add('/payment-mode/delete/{id:int}', [SettingsController::class, 'deletePaymentMode'], [
		'name' => 'payment_mode.delete',
		'methods' => 'DELETE',
	]);

	$route->add('/store-inventory/index', [SettingsController::class, 'storeInventory'], ['name' => 'store_inventory.index',]);
	$route->add('/store-inventory/{id:int}/create', [SettingsController::class, 'createStoreInventory'], [
		'name' => 'store_inventory.create',
	]);

	$route->add('/general-setting', [SettingsController::class, 'companyIndex'], ['name' => 'company.index',]);
	$route->add('/general-setting/update', [SettingsController::class, 'updateCompany'], [
		'name' => 'company.update',
		'methods' => 'PUT',
	]);

	/**
	 * MATERIALS MODULE
	*/
	$route->add('/material-type/index', [MaterialController::class, 'materialType'], ['name' => 'material_type.index',]);
	$route->add('/material-type/create', [MaterialController::class, 'createMaterialType'], [
		'name' => 'material_type.create',
		'methods' => 'POST',
	]);
	$route->add('/material-type/update/{id:int}', [MaterialController::class, 'updateMaterialType'], [
		'name' => 'material_type.update',
		'methods' => 'PUT',
	]);
	$route->add('/material-type/delete/{id:int}', [MaterialController::class, 'deleteMaterialType'], [
		'name' => 'material_type.delete',
		'methods' => 'DELETE',
	]);
	
	$route->add('/material/index', [MaterialController::class, 'material'], ['name' => 'material.index',]);
	$route->add('/material/select', [MaterialController::class, 'selectMaterial'], ['name' => 'material.select',]);
	$route->add('/material/create', [MaterialController::class, 'createMaterial'], [
		'name' => 'material.create',
		'methods' => 'POST',
	]);
	$route->add('/material/edit/{id:int}', [MaterialController::class, 'materialEdit'], ['name' => 'material.edit',]);
	$route->add('/material/update/{id:int}', [MaterialController::class, 'updateMaterial'], [
		'name' => 'material.update',
		'methods' => 'PUT',
	]);
	$route->add('/material/delete/{id:int}', [MaterialController::class, 'deleteMaterial'], [
		'name' => 'material.delete',
		'methods' => 'DELETE',
	]);

	// PRODUCT
	$route->add('/category/index', [ProductController::class, 'category'], ['name' => 'category.index',]);
	$route->add('/category/create', [ProductController::class, 'createCategory'], [
		'name' => 'category.create',
		'methods' => 'POST',
	]);
	$route->add('/category/update/{id:int}', [ProductController::class, 'updateCategory'], [
		'name' => 'category.update',
		'methods' => 'PUT',
	]);
	$route->add('/category/delete/{id:int}', [ProductController::class, 'deleteCategory'], [
		'name' => 'category.delete',
		'methods' => 'DELETE',
	]);

	$route->add('/product/index', [ProductController::class, 'product'], ['name' => 'product.index',]);
	$route->add('/product/select', [ProductController::class, 'selectProduct'], ['name' => 'product.select',]);
	$route->add('/product/data', [ProductController::class, 'productData'], ['name' => 'product.data',]);
	$route->add('/product/create', [ProductController::class, 'createProduct'], [
		'name' => 'product.create',
		'methods' => 'POST',
	]);
	$route->add('/product/edit/{id:int}', [ProductController::class, 'productEdit'], ['name' => 'product.edit',]);
	$route->add('/product/update/{id:int}', [ProductController::class, 'updateProduct'], [
		'name' => 'product.update',
		'methods' => 'PUT',
	]);
	$route->add('/product/delete/{id:int}', [ProductController::class, 'deleteProduct'], [
		'name' => 'product.delete',
		'methods' => 'DELETE',
	]);

	// Product type
	$route->add('/product-type/index', [ProductController::class, 'productType'], ['name' => 'product_type.index',]);
	$route->add('/product-type/create', [ProductController::class, 'createProductType'], [
		'name' => 'product_type.create',
		'methods' => 'POST',
	]);
	$route->add('/product-type/update/{id:int}', [ProductController::class, 'updateProductType'], [
		'name' => 'product_type.update',
		'methods' => 'PUT',
	]);
	$route->add('/product-type/delete/{id:int}', [ProductController::class, 'deleteProductType'], [
		'name' => 'product_type.delete',
		'methods' => 'DELETE',
	]);

	// Brand
	$route->add('/brand/index', [ProductController::class, 'brand'], ['name' => 'brand.index',]);
	$route->add('/brand/create', [ProductController::class, 'createBrand'], [
		'name' => 'brand.create',
		'methods' => 'POST',
	]);
	$route->add('/brand/update/{id:int}', [ProductController::class, 'updateBrand'], [
		'name' => 'brand.update',
		'methods' => 'PUT',
	]);
	$route->add('/brand/delete/{id:int}', [ProductController::class, 'deleteBrand'], [
		'name' => 'brand.delete',
		'methods' => 'DELETE',
	]);

	// Unit
	$route->add('/unit/index', [ProductController::class, 'unit'], ['name' => 'unit.index',]);
	$route->add('/unit/create', [ProductController::class, 'createUnit'], [
		'name' => 'unit.create',
		'methods' => 'POST',
	]);
	$route->add('/unit/update/{id:int}', [ProductController::class, 'updateUnit'], [
		'name' => 'unit.update',
		'methods' => 'PUT',
	]);
	$route->add('/unit/delete/{id:int}', [ProductController::class, 'deleteUnit'], [
		'name' => 'unit.delete',
		'methods' => 'DELETE',
	]);

	// INVENTORY
	/*$route->add('/sale/index', [InventoryController::class, 'sale'], ['name' => 'sale.index',]);
	$route->add('/sale/select', [InventoryController::class, 'selectSale'], ['name' => 'sale.select',]);
	$route->add('/sale/create', [InventoryController::class, 'createSale'], [
		'name' => 'sale.create',
		'methods' => 'POST',
	]);
	$route->add('/sale/edit/{id:int}', [InventoryController::class, 'saleEdit'], ['name' => 'sale.edit',]);
	$route->add('/sale/update/{id:int}', [InventoryController::class, 'updateSale'], [
		'name' => 'sale.update',
		'methods' => 'PUT',
	]);
	$route->add('/sale/delete/{id:int}', [InventoryController::class, 'deleteSale'], [
		'name' => 'sale.delete',
		'methods' => 'DELETE',
	]);*/

	$route->add('/store/index', [InventoryController::class, 'store'], ['name' => 'store.index',]);
	$route->add('/store/create', [InventoryController::class, 'createStore'], [
		'name' => 'store.create',
		'methods' => 'POST',
	]);
	$route->add('/store/edit/{id:int}', [InventoryController::class, 'storeEdit'], ['name' => 'store.edit',]);
	$route->add('/store/update/{id:int}', [InventoryController::class, 'updateStore'], [
		'name' => 'store.update',
		'methods' => 'PUT',
	]);
	$route->add('/store/delete/{id:int}', [InventoryController::class, 'deleteStore'], [
		'name' => 'store.delete',
		'methods' => 'DELETE',
	]);

	$route->add('/supplier/index', [InventoryController::class, 'supplier'], ['name' => 'supplier.index',]);
	$route->add('/supplier/create', [InventoryController::class, 'createSupplier'], [
		'name' => 'supplier.create',
		'methods' => 'POST',
	]);
	$route->add('/supplier/edit/{id:int}', [InventoryController::class, 'supplierEdit'], ['name' => 'supplier.edit']);
	$route->add('/supplier/update/{id:int}', [InventoryController::class, 'updateSupplier'], [
		'name' => 'supplier.update',
		'methods' => 'PUT',
	]);
	$route->add('/supplier/delete/{id:int}', [InventoryController::class, 'deleteSupplier'], [
		'name' => 'supplier.delete',
		'methods' => 'DELETE',
	]);

	$route->add('/customer/index', [InventoryController::class, 'customer'], ['name' => 'customer.index']);
	$route->add('/customer/create', [InventoryController::class, 'createCustomer'], [
		'name' => 'customer.create',
		'methods' => 'POST',
	]);
	$route->add('/customer/edit/{id:int}', [InventoryController::class, 'customerEdit'], ['name' => 'customer.edit']);
	$route->add('/customer/update/{id:int}', [InventoryController::class, 'updateCustomer'], [
		'name' => 'customer.update',
		'methods' => 'PUT',
	]);
	$route->add('/customer/delete/{id:int}', [InventoryController::class, 'deleteCustomer'], [
		'name' => 'customer.delete',
		'methods' => 'DELETE',
	]);

	// Purchase
	$route->add('/purchase/index', [PurchaseController::class, 'purchase'], ['name' => 'purchase.index']);
	$route->add('/purchase/create', [PurchaseController::class, 'createPurchase'], [
		'name' => 'purchase.create',
		'methods' => ['POST'],
	]);
	$route->add('/purchase/edit/{id:int}', [PurchaseController::class, 'purchaseEdit'], ['name' => 'purchase.edit']);
	$route->add('/purchase/update/{id:int}', [PurchaseController::class, 'updatePurchase'], [
		'name' => 'purchase.update',
		'methods' => 'PUT',
	]);
	$route->add('/purchase/delete/{id:int}', [PurchaseController::class, 'deletePurchase'], [
		'name' => 'purchase.delete',
		'methods' => 'DELETE',
	]);

	// Stock
	$route->add('/stock/index', [PurchaseController::class, 'stock'], ['name' => 'stock.index',]);
	$route->add('/stock/create', [PurchaseController::class, 'createStock'], [
		'name' => 'stock.create',
		'methods' => 'POST',
	]);
	$route->add('/stock/edit/{id:int}', [PurchaseController::class, 'stockEdit'], ['name' => 'stock.edit',]);
	$route->add('/stock/update/{id:int}', [PurchaseController::class, 'updateStock'], [
		'name' => 'stock.update',
		'methods' => 'PUT',
	]);
	$route->add('/stock/delete/{id:int}', [PurchaseController::class, 'deleteStock'], [
		'name' => 'stock.delete',
		'methods' => 'DELETE',
	]);

	// Sale
	$route->add('/sale/index', [PurchaseController::class, 'sale'], ['name' => 'sale.index',]);
	$route->add('/sale/add', [PurchaseController::class, 'saleAdd'], ['name' => 'sale.add',]);
	$route->add('/sale/create', [PurchaseController::class, 'createSale'], [
		'name' => 'sale.create',
		'methods' => 'POST',
	]);
	$route->add('/sale/edit/{id:int}', [PurchaseController::class, 'saleEdit'], ['name' => 'sale.edit',]);
	$route->add('/sale/update/{id:int}', [PurchaseController::class, 'updateSale'], [
		'name' => 'sale.update',
		'methods' => 'PUT',
	]);
	$route->add('/sale/delete/{id:int}', [PurchaseController::class, 'deleteSale'], [
		'name' => 'sale.delete',
		'methods' => 'DELETE',
	]);

	$route->add('/invoice/index', [PurchaseController::class, 'invoice'], ['name' => 'invoice.index',]);
	$route->add('/invoice/details/{id:int}/{invoice_no:int}', [PurchaseController::class, 'invoiceDetails'], ['name' => 'invoice.detail',]);
	$route->add('/invoice/delete/{id:int}', [PurchaseController::class, 'deleteInvoice'], [
		'name' => 'invoice.delete',
		'methods' => 'DELETE',
	]);

	// Payment
	$route->add('/payment/index', [PurchaseController::class, 'payment'], ['name' => 'payment.index']);
	$route->add('/payment/create', [PurchaseController::class, 'createPayment'], [
		'name' => 'payment.create',
		'methods' => 'POST',
	]);
	$route->add('/payment/update/{id:int}', [PurchaseController::class, 'updatePayment'], [
		'name' => 'payment.update',
		'methods' => 'PUT',
	]);
	$route->add('/payment/delete/{id:int}', [PurchaseController::class, 'deletePayment'], [
		'name' => 'payment.delete',
		'methods' => 'DELETE',
	]);

	/**
	 * INFORMATION MODULE
	*/
	$route->add('/notice/index', [InformationController::class, 'notice'], ['name' => 'notice.index']);
	$route->add('/notice/create', [InformationController::class, 'createNotice'], [
		'name' => 'notice.create',
		'methods' => 'POST',
	]);
	$route->add('/notice/update/{id:int}', [InformationController::class, 'updateNotice'], [
		'name' => 'notice.update',
		'methods' => 'PUT',
	]);
	$route->add('/notice/delete/{id:int}', [InformationController::class, 'deleteNotice'], [
		'name' => 'notice.delete',
		'methods' => 'DELETE',
	]);

	$route->add('/holiday/index', [InformationController::class, 'holiday'], ['name' => 'holiday.index']);
	$route->add('/holiday/create', [InformationController::class, 'createHoliday'], [
		'name' => 'holiday.create',
		'methods' => 'POST',
	]);
	$route->add('/holiday/update/{id:int}', [InformationController::class, 'updateHoliday'], [
		'name' => 'holiday.update',
		'methods' => 'PUT',
	]);
	$route->add('/holiday/delete/{id:int}', [InformationController::class, 'deleteHoliday'], [
		'name' => 'holiday.delete',
		'methods' => 'DELETE',
	]);

	$route->add('/event-type/index', [InformationController::class, 'eventType'], ['name' => 'event_type.index']);
	$route->add('/event-type/create', [InformationController::class, 'createEventType'], [
		'name' => 'event_type.create',
		'methods' => 'POST',
	]);
	$route->add('/event-type/update/{id:int}', [InformationController::class, 'updateEventType'], [
		'name' => 'event_type.update',
		'methods' => 'PUT',
	]);
	$route->add('/event-type/delete/{id:int}', [InformationController::class, 'deleteEventType'], [
		'name' => 'event_type.delete',
		'methods' => 'DELETE',
	]);

	$route->add('/event/index', [InformationController::class, 'event'], ['name' => 'event.index',]);
	$route->add('/event/select', [InformationController::class, 'selectEvent'], ['name' => 'event.select',]);
	$route->add('/event/create', [InformationController::class, 'createEvent'], [
		'name' => 'event.create',
		'methods' => 'POST',
	]);
	$route->add('/event/edit/{id:int}', [InformationController::class, 'eventEdit'], ['name' => 'event.edit',]);
	$route->add('/event/update/{id:int}', [InformationController::class, 'updateEvent'], [
		'name' => 'event.update',
		'methods' => 'PUT',
	]);
	$route->add('/event/delete/{id:int}', [InformationController::class, 'deleteEvent'], [
		'name' => 'event.delete',
		'methods' => 'DELETE',
	]);

	/**
	 * ACCOUNTING MODULE
	 */
	// Income Expense Head
	$route->add('/income-head/index', [AccountingController::class, 'incomeHead'], ['name' => 'income_head.index',]);
	$route->add('/income-head/create', [AccountingController::class, 'createIncomeHead'], [
		'name' => 'income_head.create',
		'methods' => 'POST',
	]);
	$route->add('/income-head/update/{id:int}', [AccountingController::class, 'updateIncomeHead'], [
		'name' => 'income_head.update',
		'methods' => 'PUT',
	]);
	$route->add('/income-head/delete/{id:int}', [AccountingController::class, 'deleteIncomeHead'], [
		'name' => 'income_head.delete',
		'methods' => 'DELETE',
	]);
	// Expense Head
	$route->add('/expense-head/index', [AccountingController::class, 'expenseHead'], ['name' => 'expense_head.index',]);
	$route->add('/expense-head/create', [AccountingController::class, 'createExpenseHead'], [
		'name' => 'expense_head.create',
		'methods' => 'POST',
	]);
	$route->add('/expense-head/update/{id:int}', [AccountingController::class, 'updateExpenseHead'], [
		'name' => 'expense_head.update',
		'methods' => 'PUT',
	]);
	$route->add('/expense-head/delete/{id:int}', [AccountingController::class, 'deleteExpenseHead'], [
		'name' => 'expense_head.delete',
		'methods' => 'DELETE',
	]);
	// INCOME
	$route->add('/income/index', [AccountingController::class, 'income'], ['name' => 'income.index',]);
	$route->add('/income/select', [AccountingController::class, 'selectIncome'], ['name' => 'income.select',]);
	$route->add('/income/create', [AccountingController::class, 'createIncome'], [
		'name' => 'income.create',
		'methods' => 'POST',
	]);
	$route->add('/income/edit/{id:int}', [AccountingController::class, 'incomeEdit'], ['name' => 'income.edit',]);
	$route->add('/income/update/{id:int}', [AccountingController::class, 'updateIncome'], [
		'name' => 'income.update',
		'methods' => 'PUT',
	]);
	$route->add('/income/delete/{id:int}', [AccountingController::class, 'deleteIncome'], [
		'name' => 'income.delete',
		'methods' => 'DELETE',
	]);
	// EXPENSE
	$route->add('/expense/index', [AccountingController::class, 'expense'], ['name' => 'expense.index',]);
	$route->add('/expense/select', [AccountingController::class, 'selectExpense'], ['name' => 'expense.select',]);
	$route->add('/expense/create', [AccountingController::class, 'createExpense'], [
		'name' => 'expense.create',
		'methods' => 'POST',
	]);
	$route->add('/expense/edit/{id:int}', [AccountingController::class, 'expenseEdit'], ['name' => 'expense.edit',]);
	$route->add('/expense/update/{id:int}', [AccountingController::class, 'updateExpense'], [
		'name' => 'expense.update',
		'methods' => 'PUT',
	]);
	$route->add('/expense/delete/{id:int}', [AccountingController::class, 'deleteExpense'], [
		'name' => 'expense.delete',
		'methods' => 'DELETE',
	]);
	// $route->add('/fee/invoice/pdf/{id:int}', [AccountingController::class, 'feePDF'], ['name' => 'fee.pdf',]);

	/**
	 * COMMUNICATION
	 */
	// Email Template
	$route->add('/email-template/index', [CommunicationController::class, 'emailTemplate'], ['name' => 'email_template.index',]);
	$route->add('/email-template/create', [CommunicationController::class, 'createEmailTemplate'], [
		'name' => 'email_template.create',
		'methods' => 'POST',
	]);
	$route->add('/email-template/update/{id:int}', [CommunicationController::class, 'updateEmailTemplate'], [
		'name' => 'email_template.update',
		'methods' => 'PUT',
	]);
	$route->add('/email-template/delete/{id:int}', [CommunicationController::class, 'deleteEmailTemplate'], [
		'name' => 'email_template.delete',
		'methods' => 'DELETE',
	]);
	// SMS Template
	$route->add('/sms-template/index', [CommunicationController::class, 'smsTemplate'], ['name' => 'sms_template.index',]);
	$route->add('/sms-template/create', [CommunicationController::class, 'createSmsTemplate'], [
		'name' => 'sms_template.create',
		'methods' => 'POST',
	]);
	$route->add('/sms-template/update/{id:int}', [CommunicationController::class, 'updateSmsTemplate'], [
		'name' => 'sms_template.update',
		'methods' => 'PUT',
	]);
	$route->add('/sms-template/delete/{id:int}', [CommunicationController::class, 'deleteSmsTemplate'], [
		'name' => 'sms_template.delete',
		'methods' => 'DELETE',
	]);
	// Email Config
	$route->add('/email-config/index', [CommunicationController::class, 'emailConfig'], ['name' => 'email_config.index',]);
	$route->add('/email-config/create', [CommunicationController::class, 'createEmailConfig'], [
		'name' => 'email_config.create',
		'methods' => 'POST',
	]);
	$route->add('/email-config/edit/{id:int}', [CommunicationController::class, 'emailConfigEdit'], ['name' => 'email_config.edit',]);
	$route->add('/email-config/update/{id:int}', [CommunicationController::class, 'updateEmailConfig'], [
		'name' => 'email_config.update',
		'methods' => 'PUT',
	]);
	$route->add('/email-config/delete/{id:int}', [CommunicationController::class, 'deleteEmailConfig'], [
		'name' => 'email_config.delete',
		'methods' => 'DELETE',
	]);
	// SMS Config
	$route->add('/sms-config/index', [CommunicationController::class, 'smsConfig'], ['name' => 'sms_config.index',]);
	$route->add('/sms-config/create', [CommunicationController::class, 'createSmsConfig'], [
		'name' => 'sms_config.create',
		'methods' => 'POST',
	]);
	$route->add('/sms-config/edit/{id:int}', [CommunicationController::class, 'smsConfigEdit'], ['name' => 'sms_config.edit',]);
	$route->add('/sms-config/update/{id:int}', [CommunicationController::class, 'updateSmsConfig'], [
		'name' => 'sms_config.update',
		'methods' => 'PUT',
	]);
	$route->add('/sms-config/delete/{id:int}', [CommunicationController::class, 'deleteSmsConfig'], [
		'name' => 'sms_config.delete',
		'methods' => 'DELETE',
	]);
	$route->add('/email-send/index', [CommunicationController::class, 'emailSendForm'], ['name' => 'email_send.index',]);
	$route->add('/email/send', [CommunicationController::class, 'emailSend'], [
		'name' => 'email_send.create',
		'methods' => 'POST',
	]);

	$route->add('/reports/income', [ReportController::class, 'income'], ['name' => 'income_report.index',]);
	$route->add('/low-inventory/notification', [ReportController::class, 'lowInventory'], ['name' => 'low_inventory.index',]);
});

$route->add('/user/login', [UserController::class, 'login'], [
		'name' => 'user.login',
		'methods' => ['GET', 'POST'],
	]);

$route->group(['prefix' => '/image', 'name' => 'image'], function($route) {
	$route->add('/staff', [FileController::class, 'staff'], ['name' => 'staff']);
	$route->add('/event', [FileController::class, 'event'], ['name' => 'event']);
	$route->add('/brand', [FileController::class, 'brand'], ['name' => 'brand']);
	$route->add('/product', [FileController::class, 'product'], ['name' => 'product']);
	$route->add('/company', [FileController::class, 'company'], ['name' => 'company']);
});

$route->group(['prefix' => '/file', 'name' => 'file'], function($route) {
	$route->add('/material', [FileController::class, 'material'], ['name' => 'material']);
	$route->add('/leave', [FileController::class, 'leave'], ['name' => 'leave']);
	$route->add('/income', [FileController::class, 'income'], ['name' => 'income']);
	$route->add('/expense', [FileController::class, 'expense'], ['name' => 'expense']);
	$route->add('/staff/documents', [FileController::class, 'staffDocument'], ['name' => 'staff_document']);
});

$route->add('/invoice/pdf', [PurchaseController::class, 'invoicePdf'], ['name' => 'invoice_pdf']);
$route->add('/material/pdf', [FileController::class, 'materialPDF'], ['name' => 'material_pdf']);
