<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Supplier extends Model 
{

    public static function schema(): array 
    {
        return [
            'company' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = true;
            }),

            'name' => Field::CharField(function(Column $column) {        
                $column->size = 50;
                $column->null = false;
            }),

            'email' => Field::CharField(function(Column $column) {    
                $column->size = 100; 
                $column->null = true;
            }),

            'phone' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = false;
            }),

            'address' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = true;
            }),

            'note' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = true;
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }),       
        ];
    }

    public function __toString() 
    {
        return $this->company;
    }
}
