<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Store extends Model 
{

    public static function schema(): array 
    {
        return [
            'name' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),

            'code' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = true;
            }),

            'type' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = true;
            }),

            'note' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = true;
            }),

            'address' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = true;
            }),

            'manager' => Field::ManyToOneField(Staff::class, function(Column $column) { 
                $column->null = true;
            }, Index::INDEX, ForeignKey::NULLIFY),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 

            'inventorys' => Relationship::OneToMany(
                Inventory::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'store';
                }
            ),        
        ];
    }

    public function __toString() 
    {
        return $this->name;
    }
}
