<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Stock extends Model 
{

    public static function schema(): array 
    {
        return [
            'inventory' => Field::ManyToOneField(Inventory::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'purchase' => Field::ManyToOneField(Purchase::class, function(Column $column) { 
                $column->null = true;
            }, Index::INDEX, ForeignKey::NULLIFY),

            'quantity' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = false;
            }),

            'batch_code' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
            }),

            'remark' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = true;
            }),

            'date' => Field::CharField(function (Column $column) {
                $column->size = 25;
                $column->null = true;
            }), 

            'price' => Field::CharField(function (Column $column) {
                $column->size = 25;
                $column->null = true;
            }), 

            'expiry' => Field::CharField(function (Column $column) {
                $column->size = 25;
                $column->null = true;
            }), 

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 
      
        ];
    }

}
