<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Staff extends Model 
{
    public static function schema(): array 
    {
        return [
            'firstname' => Field::CharField(function(Column $column) {        
                $column->size = 50;
                $column->null = false;
            }),

            'lastname' => Field::CharField(function(Column $column) {        
                $column->size = 50;
                $column->null = false;
            }),

            'othername' => Field::CharField(function(Column $column) {        
                $column->size = 50;
                $column->null = true;
            }),

            'email' => Field::CharField(function (Column $column) {
                $column->size = 100;
                $column->null = true;
            }, Index::UNIQUE),  

            'phone' => Field::CharField(function(Column $column) {        
                $column->size = 25;
                $column->null = true;
            }, Index::UNIQUE),

            'dob' => Field::CharField(function(Column $column) {   
                $column->size = 25; 
                $column->null = true;
            }),

            'gender' => Field::EnumField(function(Column $column) {        
                $column->size = array('male', 'female');
                $column->null = false;
            }),

            'marital_status' => Field::CharField(function(Column $column) {        
                $column->size = 25; 
                $column->null = true;
            }),

            'religion' => Field::CharField(function(Column $column) {        
                $column->size = 50;
                $column->null = true;
            }),

            'photo' => Field::CharField(function(Column $column) {        
                $column->size = 100;
                $column->null = true;
            }),

            'address' => Field::CharField(function(Column $column) {        
                $column->size = 255;
                $column->null = true;
            }),

            'city' => Field::CharField(function(Column $column) {        
                $column->size = 50;
                $column->null = true;
            }), 

            'state' => Field::CharField(function(Column $column) {        
                $column->size = 50;
                $column->null = true;
            }),

            'country' => Field::CharField(function(Column $column) {        
                $column->size = 50;
                $column->null = true;
            }),  

            'staff_num' => Field::CharField(function(Column $column) {        
                $column->size = 25;
                $column->null = true;
            }),

            'join_date' => Field::CharField(function(Column $column) {  
                $column->size = 25;      
                $column->null = true;
            }),

            'qualification' => Field::CharField(function(Column $column) {        
                $column->size = 255;
                $column->null = true;
            }),

            'experience' => Field::CharField(function(Column $column) {        
                $column->size = 255;
                $column->null = true;
            }),

            'role' => Field::ManyToOneField(Role::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'designation' => Field::ManyToOneField(Designation::class, function(Column $column) { 
                $column->null = true;
            }, Index::INDEX, ForeignKey::NULLIFY),

            'department' => Field::ManyToOneField(Department::class, function(Column $column) { 
                $column->null = true;
            }, Index::INDEX, ForeignKey::NULLIFY),

            'appointment' => Field::CharField(function(Column $column) {        
                $column->size = 25; 
                $column->null = true;
            }),

            'salary' => Field::ManyToOneField(Salary::class, function(Column $column) { 
                $column->null = true;
            }, Index::INDEX, ForeignKey::NULLIFY),

            'alt_contact' => Field::CharField(function(Column $column) {        
                $column->size = 255;
                $column->null = true;
            }),

            'username' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }, Index::UNIQUE),

            'password' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = false;
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = fn () => date("Y-m-d H:i:s");
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }),  

            'account' => Relationship::OneToOne(
                Account::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'staff';
                }
            ), 

            'social_num' => Relationship::OneToOne(
                SocialNumber::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'staff';
                }
            ), 

            'documents' => Relationship::OneToMany(
                StaffDocument::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'staff';
                }
            ), 

            'attendances' => Relationship::OneToMany(
                StaffAttendance::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'staff';
                }
            ), 

            'payslips' => Relationship::OneToMany(
                Payslip::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'staff';
                }
            ), 

            'leaves' => Relationship::OneToMany(
                Leave::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'staff';
                }
            ), 

            'socials' => Relationship::ManyToMany(
                Social::class, 
                function(Relationship $relationship) { 
                    $relationship->through = StaffSocial::class;
                    $relationship->fromField = 'staff';
                    $relationship->toField = 'social';
                }
            ), 

            'handles' => Relationship::OneToMany(
                StaffSocial::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'staff';
                }
            ),    
        ];
    }

    public function __toString() 
    {
        return "$this->firstname $this->lastname";
    }

    public function save($create = false)
    {
        if ($create) {
            $this->password = password_hash($this->password, PASSWORD_DEFAULT);
        }
        
        return parent::save();
    }
}
