<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class SocialNumber extends Model 
{

    public static function schema(): array 
    {
        return [
            'type' => Field::EnumField(function(Column $column) {
                $column->size = array("national id", "drivers licence", "voters card", "international passport");
                $column->null = false;
            }),

            'number' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),

            'staff' => Field::OneToOneField(Staff::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 
       
        ];
    }

    public function __toString() 
    {
        return $this->type;
    }
}
