<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Social extends Model 
{

    public static function schema(): array 
    {
        return [
            'handle' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }, Index::UNIQUE),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 

            'staff' => Relationship::ManyToMany(
                Staff::class, 
                function(Relationship $relationship) { 
                    $relationship->through = StaffSocial::class;
                    $relationship->fromField = 'social';
                    $relationship->toField = 'staff';
                }
            ),        
        ];
    }

    public function __toString() 
    {
        return $this->handle;
    }
}
