<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class SmsConfig extends Model 
{

    public static function schema(): array 
    {
        return [
            'type' => Field::CharField(function(Column $column) { 
                $column->size = 50;
                $column->null = false;
            }),

            'name' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),

            'api_id' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = false;
            }),

            'auth_key' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = false;
            }),

            'sender_id' => Field::CharField(function(Column $column) {    
                $column->size = 100; 
                $column->null = false;
            }),

            'contact' => Field::TextField(function(Column $column) {    
                $column->size = 255; 
                $column->null = true;
            }),

            'url' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = true;
            }),

            'username' => Field::CharField(function(Column $column) {    
                $column->size = 100; 
                $column->null = true;
            }),

            'password' => Field::CharField(function(Column $column) {    
                $column->size = 100; 
                $column->null = true;
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 
        ];
    }

    public function __toString() 
    {
        return $this->name;
    }
}
