<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Sale extends Model 
{

    public static function schema(): array 
    {
        return [
            'inventory' => Field::ManyToOneField(Inventory::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'quantity' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = false;
            }),

            'unit_price' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
            }),

            'total_price' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
            }),

            'invoice' => Field::ManyToOneField(Invoice::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'remark' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = true;
            }),

            'return_date' => Field::CharField(function (Column $column) {
                $column->size = 25;
                $column->null = true;
            }), 

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }),      
        ];
    }

}
