<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class SalaryDetail extends Model 
{

    public static function schema(): array 
    {
        return [
            'name' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),

            'amount' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
            }),

            'type' => Field::EnumField(function(Column $column) {
                $column->size = array('allowance', 'deduction');
                $column->null = false;
            }),

            'salary' => Field::ManyToOneField(Salary::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = fn () => date("Y-m-d H:i:s");
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }),         
        ];
    }

    public function __toString() 
    {
        return $this->name;
    }
}
