<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Salary extends Model 
{

    public static function schema(): array 
    {
        return [
            'grade' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),

            'basic' => Field::CharField(function(Column $column) {
                $column->size = 100;
                $column->null = false;
            }),

            'overtime' => Field::CharField(function(Column $column) {
                $column->size = 100;
                $column->null = true;
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = fn () => date("Y-m-d H:i:s");
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 

            'salary_details' => Relationship::OneToMany(
                SalaryDetail::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'salary';
                }
            ),         
        ];
    }

    public function __toString() 
    {
        return $this->grade;
    }
}
