<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class RolePermission extends Model 
{
    public static function schema(): array 
    {
        return [
            'role' => Field::ManyToOneField(Role::class, function(Column $column) {    
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'permission' => Field::ManyToOneField(Permission::class, function(Column $column) {    
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'can_create' => Field::EnumField(function(Column $column) {    
                $column->size = array('0', '1'); 
                $column->null = true;
                $column->default = '0';
            }),

            'can_read' => Field::EnumField(function(Column $column) {    
                $column->size = array('0', '1'); 
                $column->null = true;
                $column->default = '0';
            }),

            'can_update' => Field::EnumField(function(Column $column) {    
                $column->size = array('0', '1'); 
                $column->null = true;
                $column->default = '0';
            }),

            'can_delete' => Field::EnumField(function(Column $column) {    
                $column->size = array('0', '1'); 
                $column->null = true;
                $column->default = '0';
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 
      
        ];
    }

}
