<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Role extends Model 
{

    public static function schema(): array 
    {
        return [
            'name' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),

            'slug' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),
            
            'system' => Field::EnumField(function(Column $column) {    
                $column->size = array('0', '1'); 
                $column->null = true;
                $column->default = '1';
            }),

            'superadmin' => Field::EnumField(function(Column $column) {    
                $column->size = array('0', '1'); 
                $column->null = true;
                $column->default = '0';
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 

            'permissions' => Relationship::ManyToMany(
                Permission::class, 
                function(Relationship $relationship) { 
                    $relationship->through = RolePermission::class;
                    $relationship->fromField = 'role';
                    $relationship->toField = 'permission';
                }
            ),   

            'role_permissions' => Relationship::OneToMany(
                RolePermission::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'role';
                }
            ), 

            'employees' => Relationship::OneToMany(
                Staff::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'role';
                }
            ), 
        ];
    }

    public function __toString() 
    {
        return $this->name;
    }
}
