<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Purchase extends Model 
{

    public static function schema(): array 
    {
        return [
            'product' => Field::ManyToOneField(Product::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'supplier' => Field::ManyToOneField(Supplier::class, function(Column $column) { 
                $column->null = true;
            }, Index::INDEX, ForeignKey::NULLIFY),

            'quantity' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = false;
            }),

            'purchase_price' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
            }),

            'selling_price' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
            }),

            'profit_margin' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
            }),

            'profit_percentage' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
            }),

            'batch_code' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
            }),

            'remark' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = true;
            }),

            'date' => Field::CharField(function (Column $column) {
                $column->size = 25;
                $column->null = true;
            }), 

            'price_update' => Field::EnumField(function(Column $column) {
                $column->size = array('drop', 'normal', 'top');
                $column->null = true;
                $column->default = 'normal';
            }), 

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 
        ];
    }
}
