<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Product extends Model 
{

    public static function schema(): array 
    {
        return [
            'category' => Field::ManyToOneField(Category::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'name' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),

            'code' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
            }),

            'size' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = true;
            }),

            'unit' => Field::ManyToOneField(Unit::class, function(Column $column) { 
                $column->null = true;
            }, Index::INDEX, ForeignKey::NULLIFY),

            'pack' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = true;
            }),

            'type' => Field::ManyToOneField(ProductType::class, function(Column $column) { 
                $column->null = true;
            }, Index::INDEX, ForeignKey::NULLIFY),

            'note' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = true;
            }),

            'image' => Field::CharField(function(Column $column) {
                $column->size = 100;
                $column->null = true;
            }),

            'price' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = true;
            }),

            'brand' => Field::ManyToOneField(Brand::class, function(Column $column) { 
                $column->null = true;
            }, Index::INDEX, ForeignKey::NULLIFY),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 

            'inventorys' => Relationship::OneToMany(
                Inventory::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'product';
                }
            ),        
        ];
    }

    public function __toString() 
    {
        return $this->name;
    }
}
