<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Permission extends Model 
{

    public static function schema(): array 
    {
        return [
            'name' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),

            'slug' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),
            
            'module' => Field::ManyToOneField(Module::class, function(Column $column) {    
                    $column->null = true;
                }, Index::INDEX, ForeignKey::NULLIFY),

            'enable_create' => Field::EnumField(function(Column $column) {    
                $column->size = array('0', '1'); 
                $column->null = true;
                $column->default = '0';
            }),

            'enable_read' => Field::EnumField(function(Column $column) {    
                $column->size = array('0', '1'); 
                $column->null = true;
                $column->default = '0';
            }),

            'enable_update' => Field::EnumField(function(Column $column) {    
                $column->size = array('0', '1'); 
                $column->null = true;
                $column->default = '0';
            }),

            'enable_delete' => Field::EnumField(function(Column $column) {    
                $column->size = array('0', '1'); 
                $column->null = true;
                $column->default = '0';
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 

            'roles' => Relationship::ManyToMany(
                Role::class, 
                function(Relationship $relationship) { 
                    $relationship->through = RolePermission::class;
                    $relationship->fromField = 'permission';
                    $relationship->toField = 'role';
                }
            ),      

            'role_permissions' => Relationship::OneToMany(
                RolePermission::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'permission';
                }
            ),   
        ];
    }

    public function __toString() 
    {
        return $this->name;
    }
}
