<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Payslip extends Model 
{

    public static function schema(): array 
    {
        return [
            'staff' => Field::ManyToOneField(Staff::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'basic_salary' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = false;
            }),

            'total_allowance' => Field::CharField(function(Column $column) {        
                $column->size = 25;
                $column->null = true;
            }),

            'total_deduction' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = true;
            }),

            'tax' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = true;
            }),

            'net_salary' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
            }),

            'bill_num' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = true;
            }),

            'month' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
            }),

            'year' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
            }),

            'remark' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = true;
            }),

            'payment_date' => Field::CharField(function (Column $column) {
                $column->size = 25;
                $column->null = true;
            }),  

            'payment_mode' => Field::ManyToOneField(PaymentMode::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'status' => Field::EnumField(function(Column $column) {        
                $column->size = array('pending', 'paid');
                $column->null = false;
                $column->default = 'pending';
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }),    

            'payslip_details' => Relationship::OneToMany(
                PayslipDetail::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'payslip';
                }
            ),      
        ];
    }

}
