<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Payment extends Model 
{

    public static function schema(): array 
    {
        return [
            'invoice' => Field::ManyToOneField(Invoice::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'date' => Field::CharField(function (Column $column) {
                $column->size = 25;
                $column->null = true;
            }), 

            'amount' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = false;
            }),

            'payment_mode' => Field::ManyToOneField(PaymentMode::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'balance' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = true;
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }),         
        ];
    }
}
