<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Notice extends Model 
{

    public static function schema(): array 
    {
        return [
            'title' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),

            'message' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = true;
            }),

            'date' => Field::CharField(function (Column $column) {
                $column->size = 25;
                $column->null = true;
            }), 

            'time' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = true;
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 
            
            'audiences' => Relationship::ManyToMany(
                Role::class, 
                function(Relationship $relationship) { 
                    $relationship->through = NoticeAudience::class;
                    $relationship->fromField = 'notice';
                    $relationship->toField = 'audience';
                }
            ), 
        ];
    }

    public function __toString() 
    {
        return $this->title;
    }
}
