<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Module extends Model 
{

    public static function schema(): array 
    {
        return [
            'name' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),

            'slug' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),
            
            'system' => Field::EnumField(function(Column $column) {    
                $column->size = array('0', '1'); 
                $column->null = true;
                $column->default = '1';
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 

            'permissions' => Relationship::OneToMany(
                Permission::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'module';
                }
            ),        
        ];
    }

    public function __toString() 
    {
        return $this->name;
    }
}
