<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Leave extends Model 
{
    public static function schema(): array 
    {
        return [
            'staff' => Field::ManyToOneField(Staff::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'leave_type' => Field::ManyToOneField(LeaveType::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'from' => Field::CharField(function(Column $column) {    
                $column->size = 25;
                $column->null = false;
            }),

            'to' => Field::CharField(function(Column $column) {    
                $column->size = 25;
                $column->null = false;
            }),

            'status' => Field::EnumField(function(Column $column) {        
                $column->size = array('pending', 'approved', 'declined');
                $column->null = false;
                $column->default = 'pending';
            }),

            'reason' => Field::CharField(function(Column $column) {        
                $column->size = 255;
                $column->null = true;
            }),

            'remark' => Field::CharField(function(Column $column) {        
                $column->size = 255;
                $column->null = true;
            }),

            'file' => Field::CharField(function(Column $column) {        
                $column->size = 100;
                $column->null = true;
            }),

            'approved_by' => Field::ManyToOneField(Staff::class, function(Column $column) { 
                $column->null = true;
            }, Index::INDEX, ForeignKey::NULLIFY),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }),         
        ];
    }

}
