<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Invoice extends Model 
{

    public static function schema(): array 
    {
        return [
            'customer' => Field::ManyToOneField(Customer::class, function(Column $column) { 
                $column->null = true;
            }, Index::INDEX, ForeignKey::NULLIFY),

            'issuer' => Field::ManyToOneField(Staff::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'date' => Field::CharField(function (Column $column) {
                $column->size = 25;
                $column->null = true;
            }), 

            'amount' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = false;
            }),

            'paid' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = false;
                $column->default = '0';
            }),

            'balance' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = false;
                $column->default = '0';
            }),

            'discount' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = true;
            }),

            'bill_code' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = true;
            }, Index::UNIQUE),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }),   

            'sales' => Relationship::OneToMany(
                Sale::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'invoice';
                }
            ), 

            'payments' => Relationship::OneToMany(
                Payment::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'invoice';
                }
            ), 
      
        ];
    }
}
