<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Inventory extends Model 
{

    public static function schema(): array 
    {
        return [
            'store' => Field::ManyToOneField(Store::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'product' => Field::ManyToOneField(Product::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'quantity' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = false;
                $column->default = '0';
            }),

            'low' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
                $column->default = '0';
            }),

            'status' => Field::EnumField(function(Column $column) {    
                $column->size = array('low', 'normal'); 
                $column->null = true;
                $column->default = 'normal';
            }),

            'symbol' => Field::EnumField(function(Column $column) {
                $column->size = array('-', '+');
                $column->null = false;
                $column->default = '+';
            }), 

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 
      
        ];
    }

}
