<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class IncomeHead extends Model 
{

    public static function schema(): array 
    {
        return [
            'inname' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),

            'note' => Field::CharField(function(Column $column) {
                $column->size = 255;
                $column->null = true;
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 

            'incomes' => Relationship::OneToMany(
                Income::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'income_head';
                }
            ),    
        ];
    }

    public function __toString() 
    {
        return $this->inname;
    }
}
