<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Holiday extends Model 
{

    public static function schema(): array 
    {
        return [
            'title' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),

            'description' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = true;
            }),

            'start_date' => Field::CharField(function (Column $column) {    
                $column->size = 25; 
                $column->null = true;
            }), 

            'close_date' => Field::CharField(function (Column $column) {    
                $column->size = 25;
                $column->null = true;
            }), 

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 
       
        ];
    }

    public function __toString() 
    {
        return $this->title;
    }
}
