<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Expense extends Model 
{

    public static function schema(): array 
    {
        return [
            'expense_head' => Field::ManyToOneField(ExpenseHead::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'title' => Field::CharField(function(Column $column) {
                $column->size = 100;
                $column->null = false;
            }),

            'ref_num' => Field::CharField(function(Column $column) {    
                $column->size = 50; 
                $column->null = true;
            }),

            'amount' => Field::CharField(function(Column $column) {        
                $column->size = 25;
                $column->null = false;
            }),

            'attachment' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = true;
            }),

            'date' => Field::CharField(function (Column $column) {
                $column->size = 25;
                $column->null = true;
            }), 

            'paid_via' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = true;
            }),

            'description' => Field::CharField(function(Column $column) {        
                $column->size = 255;
                $column->null = true;
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 

        ];
    }

    public function __toString() 
    {
        return $this->title;
    }
}
