<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class EventInvitee extends Model 
{

    public static function schema(): array 
    {
        return [
            'event' => Field::ManyToOneField(Event::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'invitee' => Field::ManyToOneField(Role::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }),         
        ];
    }
}
