<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Event extends Model 
{

    public static function schema(): array 
    {
        return [
            'type' => Field::ManyToOneField(EventType::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'title' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),

            'description' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = true;
            }),

            'venue' => Field::CharField(function(Column $column) {    
                $column->size = 255; 
                $column->null = true;
            }),

            'start_date' => Field::CharField(function (Column $column) {
                $column->size = 25;
                $column->null = true;
            }), 

            'close_date' => Field::CharField(function (Column $column) {
                $column->size = 25;
                $column->null = true;
            }), 

            'image' => Field::CharField(function(Column $column) {    
                $column->size = 100; 
                $column->null = true;
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 

            'invitees' => Relationship::ManyToMany(
                Role::class, 
                function(Relationship $relationship) { 
                    $relationship->through = EventInvitee::class;
                    $relationship->fromField = 'event';
                    $relationship->toField = 'invitee';
                }
            ), 
       
        ];
    }

    public function __toString() 
    {
        return $this->title;
    }
}
