<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class EmailTemplate extends Model 
{

    public static function schema(): array 
    {
        return [
            'subject' => Field::CharField(function(Column $column) {
                $column->size = 100;
                $column->null = false;
            }),

            'message' => Field::TextField(function(Column $column) {
                $column->null = false;
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 
        
        ];
    }

    public function __toString() 
    {
        return $this->subject;
    }
}
