<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class EmailConfig extends Model 
{

    public static function schema(): array 
    {
        return [
            'gateway' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = true;
            }),

            'email' => Field::CharField(function(Column $column) {    
                $column->size = 100; 
                $column->null = true;
            }),

            'protocol' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = true;
            }),

            'smtp_host' => Field::CharField(function (Column $column) {
                $column->size = 50;
                $column->null = true;
            }), 

            'smtp_user' => Field::CharField(function (Column $column) {
                $column->size = 50;
                $column->null = true;
            }), 

            'smtp_pass' => Field::CharField(function (Column $column) {
                $column->size = 50;
                $column->null = true;
            }), 

            'smtp_port' => Field::CharField(function (Column $column) {
                $column->size = 25;
                $column->null = true;
            }), 

            'encryption' => Field::CharField(function (Column $column) {
                $column->size = 25;
                $column->null = true;
            }), 

            'smtp_auth' => Field::EnumField(function (Column $column) {
                $column->size = array('0', '1');
                $column->null = true;
                $column->default = '0';
            }), 

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 
        ];
    }
}
