<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Company extends Model 
{

    public static function schema(): array 
    {
        return [
            'name' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),

            'logo' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = true;
            }),

            'phone' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = false;
            }),

            'email' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = false;
            }),

            'phone2' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
            }),

            'email2' => Field::CharField(function(Column $column) {
                $column->size = 50;
                $column->null = true;
            }),

            'address' => Field::CharField(function(Column $column) {
                $column->size = 255;
                $column->null = true;
            }),

            'note' => Field::CharField(function(Column $column) {
                $column->size = 255;
                $column->null = true;
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }),  
        ];
    }

    public function __toString() 
    {
        return $this->name;
    }
}
