<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class Category extends Model 
{

    public static function schema(): array
    {
        return [
            'name' => Field::CharField(function (Column $column) {
                $column->size = 50;
                $column->null = false;
            }, Index::UNIQUE),

            'description' => Field::CharField(function (Column $column) {
                $column->size = 255;
                $column->null = true;
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }),    

            'products' => Relationship::OneToMany(
                Product::class, 
                function(Relationship $relationship) { 
                    $relationship->backref = 'category';
                }
            ),     
        ];
    }

    public function __toString() 
    {
        return $this->name;
    }
}
