<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;


class BulkSend extends Model 
{

    public static function schema(): array 
    {
        return [
            'gateway' => Field::CharField(function(Column $column) {        
                $column->size = 255;
                $column->null = false;
            }),

            'subject' => Field::CharField(function(Column $column) {
                $column->size = 100;
                $column->null = true;
            }),

            'message' => Field::TextField(function(Column $column) {    
                $column->null = false;
            }),

            'message_type' => Field::EnumField(function(Column $column) {
                $column->size = array('email', 'sms');
                $column->null = false;
            }),

            'receiver_type' => Field::EnumField(function(Column $column) {    
                $column->size = array('group', 'class', 'individual'); 
                $column->null = false;
            }),

            'receiver_details' => Field::TextField(function(Column $column) {    
                $column->null = true;
            }),

            'schedule_time' => Field::DateTimeField(function(Column $column) {        
                $column->null = true;
            }),

            'status' => Field::EnumField(function(Column $column) {
                $column->size = array('pending', 'scheduled', 'completed', 'delivered');
                $column->null = true;
                $column->default = 'pending';
            }),

            'total_thread' => Field::CharField(function(Column $column) {    
                $column->size = 25; 
                $column->null = true;
            }),

            'remark' => Field::CharField(function(Column $column) {        
                $column->size = 255;
                $column->null = true;
            }),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }), 

        ];
    }

    public function __toString() 
    {
        return $this->subject;
    }
}
