<?php

namespace App\Models;

use Tiyyick\Qorm\Model;
use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Relationship;
use Tiyyick\Qorm\Migration\Column;
use Tiyyick\Qorm\Migration\ForeignKey;
use Tiyyick\Qorm\Migration\Index;

class Account extends Model 
{
    public static function schema(): array 
    {
        return [
            'name' => Field::CharField(function(Column $column) {
                $column->size = 100;
                $column->null = true;
            }),

            'number' => Field::CharField(function(Column $column) {
                $column->size = 25;
                $column->null = true;
            }),

            'bank' => Field::CharField(function(Column $column) {    
                $column->size = 50; 
                $column->null = true;
            }),

            'branch' => Field::CharField(function(Column $column) {    
                $column->size = 100; 
                $column->null = true;
            }),

            'staff' => Field::OneToOneField(Staff::class, function(Column $column) { 
                $column->null = false;
            }, Index::INDEX, ForeignKey::CASCADE),

            'created_at' => Field::DateTimeField(function (Column $column) {
                $column->null = false;
                $column->default = function() { return date("Y-m-d H:i:s"); };
            }),

            'updated_at' => Field::DateTimeField(function (Column $column) {
                $column->null = true;
            }),         
        ];
    }

    public function __toString() 
    {
        return $this->name;
    }
}
