<?php

namespace App\Middlewares;

use Tiyyick\Router\Middleware;  

use App\Models\Role;
use App\Models\Permission;
use App\Models\RolePermission;

class ForbiddenMiddleware extends Middleware
{
    public function execute()
    { 
        $currentRoute = explode('.', $this->search()['name']);
        $can = 'can_';
        
        if ($currentRoute[1] == 'index' || $currentRoute[1] == 'detail') {
            $can .= 'read';
        } else if ($currentRoute[1] == 'add' || $currentRoute[1] == 'create') {
            $can .= 'create';
        } else if ($currentRoute[1] == 'edit' || $currentRoute[1] == 'update') {
            $can .= 'update';
        } else if ($currentRoute[1] == 'delete') {
            $can .= 'delete';
        }
        

        if (in_array($currentRoute[1], ['index', 'detail', 'add', 'create', 'edit', 'update', 'delete'])) {
            $perm = Permission::query()->filter(['slug' => $currentRoute[0]])->one();
            if ($perm && is_auth()) {
                $rolePerm = RolePermission::query()->filter([
                    'role' => auth()->user()->role->id, 'and',
                    'permission' => $perm->id, 'and',
                    $can => 1
                ])->one();
                // vdnd($rolePerm);
                if (! $rolePerm){
                    abort(403);
                }
            }
        }
    }
}
