<?php 
namespace App\Helpers;

use App\Models\Role;
use App\Models\Permission;
use App\Models\RolePermission;
use App\Models\Module;

class Rbac 
{

    public function get_permission($permission, $can = '')
    {
        $ci = &get_instance();
        $role_id = $ci->session->userdata('loggedin_role_id');
        if ($role_id == 1) {
            return true;
        }
        $permissions = get_staff_permissions($role_id);
        foreach ($permissions as $permObject) {
            if ($permObject->permission_prefix == $permission && $permObject->$can == '1') {
                return true;
            }
        }
        return false;
    }

    public function get_staff_permissions($id)
    {
        $ci = &get_instance();
        $sql = "SELECT `staff_privileges`.*, `permission`.`id` as `permission_id`, `permission`.`prefix` as `permission_prefix` FROM `staff_privileges` JOIN `permission` ON `permission`.`id`=`staff_privileges`.`permission_id` WHERE `staff_privileges`.`role_id` = " . $ci->db->escape($id);
        $result = $ci->db->query($sql)->result();
        return $result;
    }

    public function getPermission($role_id) {

        $role_perm = $this->CI->rolepermission_model->getPermissionByRole($role_id);


        foreach ($role_perm as $key => $value) {
            foreach ($this->perm_category as $per_cat_key => $per_cat_value) {
                if ($value->$per_cat_value == 1) {

                    $this->permissions[$value->permission_category_code . "-" . $per_cat_value] = true;
                }
            }
        }

        return $role_perm;
    }

    public function hasPrivilege($category = null, $permission = null) {

        $perm = trim($category) . "-" . trim($permission);
        $roles = $this->CI->customlib->getStaffRole();
        $logged_user_role = json_decode($roles)->name;



        if ($logged_user_role == 'Super Admin') {
            return true;
        }

        // echo  "<pre>";
        // print_r($this->permissions);
        // echo "<pre>";
        // exit;
        // if(!$this->rbac->hasPrivilege('student','can_view')){
        //   access_denied();
        //   }

        foreach ($this->userRoles as $role) {
            if ($this->hasPermission($perm)) {
                return true;
            }
        }

        return false;
    }

    public function hasPermission($permission) {
        /*echo "<pre/>";
            print_r($this->permissions);
        exit();*/
        return isset($this->permissions[$permission]);
    }

}
