<?php

namespace App\Helpers;

use App\Models\Wallet;

class Payment 
{
    private $ps_secret_key;
    private $fw_secret_key;

    public function __construct()
    {
        $ps_secret_key = Wallet::where(['name'=>'paystack'])->first()->secret;
        $this->ps_secret_key = $ps_secret_key ? $ps_secret_key : '';
        $fw_secret_key = Wallet::where(['name'=>'flutterwave'])->first()->secret;
        $this->fw_secret_key = $fw_secret_key ? $fw_secret_key : '';
    }

    # Paystack process payment function
    public function ps_process_payment($amount, $email, $callback_url, $metadata=[], $cb_err='')
    {
        // curl_request('POST', "https://api.paystack.co/transaction/initialize", );
        // curl()->post("https://api.paystack.co/transaction/initialize",);
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/transaction/initialize",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode([
                'amount' => $amount * 100,
                'email' => $email,
                'callback_url' => $callback_url,
                'metadata' => $metadata,
            ]),
            CURLOPT_HTTPHEADER => [
                "authorization: Bearer " . $this->ps_secret_key, //replace this with your own test key
                "content-type: application/json",
                "cache-control: no-cache"
            ],
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        if ($err) {
            return ! empty($cb_err) ? redirect($cb_err)->with('error', $err) : die('Curl returned error: ' . $err);
        } 

        return json_decode($response, true);
    }

    # Paystack verify payment function
    public function ps_verify_payment($reference, $cb_err)
    {
        // $reference = isset($_GET['reference']) ? $_GET['reference'] : '';
        // $reference = isset($request->reference) ? $request->reference : '';
        // if (!$reference) return redirect($cb_err)->with('error', 'Payment failed, No reference supplied');
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.paystack.co/transaction/verify/" . rawurlencode($reference),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => [
                "accept: application/json",
                "authorization: Bearer " . $this->ps_secret_key,
                "cache-control: no-cache"
            ],
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        if ($err) return redirect($cb_err)->with('error', $err);  

        return json_decode($response, true);
    }

    # Flutterwave process payment function
    public function fw_process_payment($customer, $amount, $redirect_url, $customize, , $cb_err='')
    {
        $data = [
            "tx_ref"=>\Str::random(4).time(),
            "amount"=>$amount,
            "currency"=>"NGN",
            "redirect_url"=>$redirect_url,  # "http://localhost:8000/dashboard/user/callback/" 
            "payment_options"=>"card",
            "meta"=>[
                "consumer_id"=>23,
                "consumer_mac"=>"92a3-912ba-1192a"
            ],
            "customer"=>[
                "email"=>$customer['email'],
                "phone_number"=>$customer['phone'],
                "name"=>$customer['name']
            ],
            "customizations"=>[
                "title"=>$customize['title'],  # "Subsrciption for Auto Protect", 
                "description"=>$customize['description'],  
                "logo"=>"http://localhost/johensal-concept/users/img/icon.png"
            ]
        ];

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.flutterwave.com/v3/payments",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => [
                "authorization: Bearer " . $this->fw_secret_key, //replace this with your own test key
                "content-type: application/json",
                "cache-control: no-cache"
            ],
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        if ($err) {
            return ! empty($cb_err) ? redirect($cb_err)->with('error', $err) : die('Curl returned error: ' . $err);
        } 

        return json_decode($response, true);
    }

    # Flutterwave verify payment function
    public function fw_verify_payment($transaction_id, $cb_err) 
    {
        // $reference = isset($_GET['reference']) ? $_GET['reference'] : '';
        // $reference = isset($request->reference) ? $request->reference : '';
        // if (!$reference) return redirect($cb_err)->with('error', 'Payment failed, No reference supplied');
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.flutterwave.com/v3/transactions/".rawurlencode($transaction_id)."/verify",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => [
                "accept: application/json",
                "authorization: Bearer " . $this->fw_secret_key,
                "cache-control: no-cache"
            ],
        ));
        $response = curl_exec($curl);
        $err = curl_error($curl);
        if ($err) return redirect($cb_err)->with('error', $err);  

        return json_decode($response, true);
    }
}
