<?php

namespace App\Helpers;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class Mailer 
{
    protected $config;
    protected $fromEmail;
    protected $fromName;
    protected $replyToEmail;
    protected $replyToName;

    public function __construct($mailConfig, $details = []) 
    {
        $this->config       = $mailConfig;
        $this->fromEmail    = isset($details['from_email']) ? $details['from_email'] : "";
        $this->fromName     = isset($details['from_name']) ? $details['from_name'] : "";
        $this->replyToEmail = isset($details['reply_to_email']) ? $details['reply_to_email'] : "";
        $this->replyToName  = isset($details['reply_to_name']) ? $details['reply_to_name'] : "";
    }
    
    protected function mailConfig()
    {
        $mail      = new PHPMailer();
        $app_name  = isset($this->details['name']) ? $this->details['name'] : "";
        $app_email = isset($this->details['email']) ? $this->details['email'] : "";

        if ($this->config->gateway == "smtp") {
            $mail->isSMTP();
            $mail->SMTPAuth   = $this->config->smtp_auth != "" ? $this->config->smtp_auth : "";
            $mail->SMTPSecure = $this->config->encryption;
            $mail->Host       = $this->config->smtp_host;
            $mail->Port       = $this->config->smtp_port;
            $mail->Username   = $this->config->smtp_user;
            $mail->Password   = $this->config->smtp_pass;
            $mail->setFrom($this->config->smtp_user, $app_name);
            $mail->addReplyTo($this->config->smtp_user, $this->config->smtp_user);
        } else if ($this->config->gateway == "sendmail") {
            $mail->isSendmail();
            $mail->setFrom($this->config->smtp_user, $app_name);
            $mail->addReplyTo($this->config->smtp_user, $this->config->smtp_user);
        } else {
            $mail->isSMTP();
            $mail->Host        = 'localhost';
            $mail->SMTPAuth    = false;
            $mail->SMTPAutoTLS = false;
            $mail->Port        = 25;
            $mail->setFrom($app_email, $app_name);
            $mail->addReplyTo($app_email, $app_name);
        }

        $mail->isHTML(true);
        return $mail;
    }

    public function sendMail($recipient, $subject, $message, $attachment = null, $cc = "", $bcc = "") 
    {   
        $mail          = $this->mailConfig();
        $mail->Subject = $subject;
        $mail->Body    = $message;
        $mail->AltBody = $body;
        $response      = "";

        if ($cc != "") {
            $mail->addCC($cc);
        }

        if ($bcc != "") {
            $mail->addBCC($bcc);
        }

        if (is_array($recipient)) {
            if (is_assoc($recipient)) {
                foreach ($recipient as $email => $name) {
                    $mail->addAddress($email, $name);
                }
            } else {
                foreach ($recipient as $email) {
                    $mail->addAddress($email);
                }
            }
        } else {
            $mail->addAddress($recipient);
        }
        
        if ($attachment) {
            if (isset($_FILES[$attachment]) && ! empty($_FILES[$attachment])) {
                if (count($_FILES[$attachment]['name']) > 1) {
                    //Attach multiple files one by one
                    for ($ct = 0, $ctMax = count($_FILES[$attachment]['tmp_name']); $ct < $ctMax; $ct++) {
                        //Extract an extension from the provided filename
                        $ext = PHPMailer::mb_pathinfo($_FILES[$attachment]['name'][$ct], PATHINFO_EXTENSION);
                        //Define a safe location to move the uploaded file to, preserving the extension
                        $uploadfile = tempnam(sys_get_temp_dir(), hash('sha256', $_FILES[$attachment]['name'][$ct])) . '.' . $ext;
                        $filename = $_FILES[$attachment]['name'][$ct];
                        if (move_uploaded_file($_FILES[$attachment]['tmp_name'][$ct], $uploadfile)) {
                            if (! $mail->addAttachment($uploadfile, $filename)) {
                                $response .= 'Failed to attach file ' . $filename;
                            }
                        } else {
                            $response .= 'Failed to move file to ' . $uploadfile;
                        }
                    }
                } else {
                    $ext = PHPMailer::mb_pathinfo($_FILES[$attachment]['name'], PATHINFO_EXTENSION);
                    //Define a safe location to move the uploaded file to, preserving the extension
                    $uploadfile = tempnam(sys_get_temp_dir(), hash('sha256', $_FILES[$attachment]['name'])) . '.' . $ext;

                    if (move_uploaded_file($_FILES[$attachment]['tmp_name'], $uploadfile)) {
                        //Attach the uploaded file
                        if (! $mail->addAttachment($uploadfile, $_FILES[$attachment]['name'])) {
                            $response .= 'Failed to attach file ' . $_FILES[$attachment]['name'];
                        }
                    } else {
                        $response .= 'Failed to move file to ' . $uploadfile;
                    }
                }
            }
        }

        try {
            $mail->send();
            $response .= "Message has been sent successfully";
            return $response
        } catch (Exception $e) {
            $response .= "Mailer Error: " . $mail->ErrorInfo;
            return $response
        }
    }
}
