<?php 
namespace App\Helpers;

class CSVHelper 
{

    var $fields;/** columns names retrieved after parsing */
    var $separator = ';';/** separator used to explode each line */
    var $enclosure = '"';/** enclosure used to decorate each field */
    var $max_row_size = 4096;/** maximum row size to be used for decoding */

    public function arrayToCSV($array, $download = "") 
    {
        if ($download != "") {
            header('Content-Type: application/csv');
            header('Content-Disposition: attachement; filename="' . $download . '"');
        }
        ob_start();
        $f = fopen('php://output', 'w') or show_error("Can't open php://output");
        $n = 0;
        foreach ($array as $line) {
            $n++;
            if (!fputcsv($f, $line)) {
                show_error("Can't write line $n: $line");
            }
        }
        fclose($f) or show_error("Can't close php://output");
        $str = ob_get_contents();
        ob_end_clean();
        if ($download == "") {
            return $str;
        } else {
            echo $str;
        }
    }

    public function queryToCSV($query, $headers = TRUE, $download = "") 
    {
        if (!is_object($query) OR ! method_exists($query, 'list_fields')) {
            show_error('invalid query');
        }
        $array = array();
        if ($headers) {
            $line = array();
            foreach ($query->list_fields() as $name) {
                $line[] = $name;
            }
            $array[] = $line;
        }
        foreach ($query->result_array() as $row) {
            $line = array();
            foreach ($row as $item) {
                $line[] = $item;
            }
            $array[] = $line;
        }
        echo arrayToCSV($array, $download);
    }

    public function parse_file($p_Filepath) 
    {
        $file = fopen($p_Filepath, 'r');
        $this->fields = fgetcsv($file, $this->max_row_size, $this->separator, $this->enclosure);
        $keys = str_getcsv($this->fields[0]);
        $i = 1;

        while (($row = fgetcsv($file, $this->max_row_size, $this->separator, $this->enclosure)) != false) {
            if ($row != null) { // skip empty lines
                $values = str_getcsv($row[0]);
                if (count($keys) == count($values)) {
                    $arr = array();
                    for ($j = 0; $j < count($keys); $j++) {
                        if ($keys[$j] != "") {
                            if ($keys[$j] == "admission_date(dd-mm-yyyy)" || $keys[$j] == "dob(dd-mm-yyyy)") {
                                $search = "(dd-mm-yyyy)";
                                $trimmed = str_replace($search, '', $keys[$j]);
                                $arr[$trimmed] = date('Y-m-d', strtotime($values[$j]));
                            } else {
                                $arr[$keys[$j]] = $values[$j];
                            }
                        }
                    }
                    $content[$i] = $arr;
                    $i++;
                }
            }
        }
        fclose($file);

        return $content;
    }
}
