<?php 

namespace App\Forms;

use Tiyyick\Validation\FormValidator;
use App\Models\User;

/**
 * User form
 */
class UserForm extends FormValidator
{
	// Validation rules
	function rules(): array
	{
		return [
            "name" => [
                "required" => true,
                "maxlen" => 50
            ],
            "email" => [
                "required" => true,
                "maxlen" => 50,
                "unique" => User::class
            ],
            "password" => [
                "required" => true,
                "maxlen" => 50
            ],
        ];
	}

    public function customErrors(): array
    {
        return [
            "name" => [
                "required" => "Name field is required",
                "maxlen" => "Char should not exceed 50"
            ],
            "email" => [
                "required" => "Email field is required",
                "unique" => "This email already exists",
                "maxlen" => "Char should not exceed 50"
            ]
        ];
    }

}
