<?php 

namespace App\Forms;

use Tiyyick\Validation\FormValidator;
use App\Models\Student;

/**
 * Student form
 */
class StudentForm extends FormValidator
{
	// Validation rules
	public function rules(): array
	{
		return [
            "firstname" => [
                "required" => true,
                "maxlen" => 100
            ],
            "lastname" => [
                "required" => true,
                "maxlen" => 100
            ],
            "email" => [
                "maxlen" => 100,
                "unique" => Student::class
            ],
            "phone" => [
                "unique" => Student::class
            ],
            "gender" => [
                "required" => true,
            ],
        ];
	}

    public function customErrors(): array
    {
        return [
            "firstname" => [
                "required" => "First name field is required",
                "maxlen" => "Char should not exceed 50"
            ],
            "lastname" => [
                "required" => "Last name field is required",
                "maxlen" => "Char should not exceed 50"
            ],
            "email" => [
                "unique" => "This email already exists",
                "maxlen" => "Char should not exceed 50"
            ],
            "phone" => [
                "unique" => "This phone no already exists",
            ],
        ];
    }
}
