<?php 

namespace App\Forms;

use Tiyyick\Validation\FormValidator;
use App\Models\Staff;

/**
 * Staff form
 */
class StaffForm extends FormValidator
{
	// Validation rules
	public function rules(): array
	{
		return [
            "firstname" => [
                "required" => true,
                "maxlen" => 100
            ],
            "lastname" => [
                "required" => true,
                "maxlen" => 100
            ],
            "email" => [
                "required" => true,
                "maxlen" => 100,
                "unique" => Staff::class
            ],
            "phone" => [
                "required" => true,
                "unique" => Staff::class
            ],
            "password" => ["required" => true],
            "gender" => ["required" => true,],
            'image' => [
                "required" => true,
                'maxsize' => 1024,
                'type' => 'image',
                'mimes' => ['jpeg', 'jpg', 'png', 'gif'],
                
            ],
        ];
	}

    public function customErrors(): array
    {
        return [
            "firstname" => [
                "required" => "First name field is required",
                "maxlen" => "Char should not exceed 50"
            ],
            "lastname" => [
                "required" => "Last name field is required",
                "maxlen" => "Char should not exceed 50"
            ],
            "email" => [
                "unique" => "This email already exists",
                "maxlen" => "Char should not exceed 50"
            ],
            "phone" => [
                "unique" => "This phone no already exists",
            ],
        ];
    }
}
