<?php 

namespace App\Forms;

use Tiyyick\Validation\FormValidator;

/**
 * Post form
 */
class PostForm extends FormValidator
{
	// Validation rules
	function rules(): array
	{
		return [
            "title" => [
                "required" => true,
                "maxlen" => 255
            ],
            "content" => [
                "required" => true,
            ],
            'image' => [
                // "required" => true,
                'maxsize' => 1024,
                'type' => 'image',
                'mimes' => ['jpeg', 'jpg', 'png', 'gif'],
                
            ],
        ];
	}

    public function customErrors(): array
    {
        return [
            "title" => [
                "required" => "Title field is required",
                "maxlen" => "Max length of 255"
            ],
            "content" => [
                "required" => "Content field is required",
            ]
        ];
    }

}
