<?php 

namespace App\Forms;

use Tiyyick\Validation\FormValidator;
use App\Models\Group;

/**
 * Group form
 */
class GroupForm extends FormValidator
{
	// Validation rules
	function rules(): array
	{
		return [
            "name" => [
                "required" => true,
                "maxlen" => 20
            ],
        ];
	}

    public function customErrors(): array
    {
        return [
            "name" => [
                "required" => "Name field is required",
                "maxlen" => "Char should not exceed 20"
            ],
        ];
    }

}
