<?php

use Tiyyick\Qorm\Field;
use Tiyyick\Qorm\Migration\Migration;
use Tiyyick\Qorm\Migration\SchemaBuilder;
use Tiyyick\Qorm\Migration\Schema;
use Tiyyick\Qorm\Migration\Column;

class Migration0001 extends Migration
{
	public function __construct()
	{
		$this->operations = [
			
			function(){
				return Schema::create('brand', function (SchemaBuilder $tb) {
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('logo', array (
						  'name' => 'logo',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('note', array (
						  'name' => 'note',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('bulk_message', function (SchemaBuilder $tb) {
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => false,
						));
					$tb->text('body', array (
						  'name' => 'body',
						  'type' => Field::TEXT,
						  'null' => false,
						));
					$tb->enum('type', array (
						  'name' => 'type',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => 'email',
						    1 => 'sms',
						  ),
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('bulk_send', function (SchemaBuilder $tb) {
					$tb->string('gateway', array (
						  'name' => 'gateway',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => false,
						));
					$tb->string('subject', array (
						  'name' => 'subject',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->text('message', array (
						  'name' => 'message',
						  'type' => Field::TEXT,
						  'null' => false,
						));
					$tb->enum('message_type', array (
						  'name' => 'message_type',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => 'email',
						    1 => 'sms',
						  ),
						  'null' => false,
						));
					$tb->enum('receiver_type', array (
						  'name' => 'receiver_type',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => 'group',
						    1 => 'class',
						    2 => 'individual',
						  ),
						  'null' => false,
						));
					$tb->text('receiver_details', array (
						  'name' => 'receiver_details',
						  'type' => Field::TEXT,
						  'null' => true,
						));
					$tb->datetime('schedule_time', array (
						  'name' => 'schedule_time',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->enum('status', array (
						  'name' => 'status',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => 'pending',
						    1 => 'scheduled',
						    2 => 'completed',
						    3 => 'delivered',
						  ),
						  'null' => true,
						  'default' => 'pending',
						));
					$tb->string('total_thread', array (
						  'name' => 'total_thread',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('remark', array (
						  'name' => 'remark',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('category', function (SchemaBuilder $tb) {
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('description', array (
						  'name' => 'description',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->unique('name');

				});
			},
			
			function(){
				return Schema::create('customer', function (SchemaBuilder $tb) {
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('email', array (
						  'name' => 'email',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->string('phone', array (
						  'name' => 'phone',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('address', array (
						  'name' => 'address',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('debt', array (
						  'name' => 'debt',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						  'default' => '0',
						));
					$tb->string('remark', array (
						  'name' => 'remark',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('department', function (SchemaBuilder $tb) {
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('remark', array (
						  'name' => 'remark',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('designation', function (SchemaBuilder $tb) {
					$tb->string('title', array (
						  'name' => 'title',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('email_config', function (SchemaBuilder $tb) {
					$tb->string('gateway', array (
						  'name' => 'gateway',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('email', array (
						  'name' => 'email',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->string('protocol', array (
						  'name' => 'protocol',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('smtp_host', array (
						  'name' => 'smtp_host',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('smtp_user', array (
						  'name' => 'smtp_user',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('smtp_pass', array (
						  'name' => 'smtp_pass',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('smtp_port', array (
						  'name' => 'smtp_port',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('encryption', array (
						  'name' => 'encryption',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->enum('smtp_auth', array (
						  'name' => 'smtp_auth',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => '0',
						    1 => '1',
						  ),
						  'null' => true,
						  'default' => '0',
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('email_template', function (SchemaBuilder $tb) {
					$tb->string('subject', array (
						  'name' => 'subject',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => false,
						));
					$tb->text('message', array (
						  'name' => 'message',
						  'type' => Field::TEXT,
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('event_type', function (SchemaBuilder $tb) {
					$tb->string('type', array (
						  'name' => 'type',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('description', array (
						  'name' => 'description',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->unique('type');

				});
			},
			
			function(){
				return Schema::create('expense_head', function (SchemaBuilder $tb) {
					$tb->string('exname', array (
						  'name' => 'exname',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('note', array (
						  'name' => 'note',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('holiday', function (SchemaBuilder $tb) {
					$tb->string('title', array (
						  'name' => 'title',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('description', array (
						  'name' => 'description',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('start_date', array (
						  'name' => 'start_date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('close_date', array (
						  'name' => 'close_date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('income_head', function (SchemaBuilder $tb) {
					$tb->string('inname', array (
						  'name' => 'inname',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('note', array (
						  'name' => 'note',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('leave_type', function (SchemaBuilder $tb) {
					$tb->string('type', array (
						  'name' => 'type',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('duration', array (
						  'name' => 'duration',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('material_type', function (SchemaBuilder $tb) {
					$tb->string('type', array (
						  'name' => 'type',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('remark', array (
						  'name' => 'remark',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->unique('type');

				});
			},
			
			function(){
				return Schema::create('module', function (SchemaBuilder $tb) {
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('slug', array (
						  'name' => 'slug',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->enum('system', array (
						  'name' => 'system',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => '0',
						    1 => '1',
						  ),
						  'null' => true,
						  'default' => '1',
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('notice', function (SchemaBuilder $tb) {
					$tb->string('title', array (
						  'name' => 'title',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('message', array (
						  'name' => 'message',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('date', array (
						  'name' => 'date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('time', array (
						  'name' => 'time',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('payment_mode', function (SchemaBuilder $tb) {
					$tb->string('via', array (
						  'name' => 'via',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->unique('via');

				});
			},
			
			function(){
				return Schema::create('product_type', function (SchemaBuilder $tb) {
					$tb->string('type', array (
						  'name' => 'type',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('note', array (
						  'name' => 'note',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->unique('type');

				});
			},
			
			function(){
				return Schema::create('role', function (SchemaBuilder $tb) {
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('slug', array (
						  'name' => 'slug',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->enum('system', array (
						  'name' => 'system',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => '0',
						    1 => '1',
						  ),
						  'null' => true,
						  'default' => '1',
						));
					$tb->enum('superadmin', array (
						  'name' => 'superadmin',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => '0',
						    1 => '1',
						  ),
						  'null' => true,
						  'default' => '0',
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('salary', function (SchemaBuilder $tb) {
					$tb->string('grade', array (
						  'name' => 'grade',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('basic', array (
						  'name' => 'basic',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => false,
						));
					$tb->string('overtime', array (
						  'name' => 'overtime',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('sms_config', function (SchemaBuilder $tb) {
					$tb->string('type', array (
						  'name' => 'type',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('api_id', array (
						  'name' => 'api_id',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => false,
						));
					$tb->string('auth_key', array (
						  'name' => 'auth_key',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => false,
						));
					$tb->string('sender_id', array (
						  'name' => 'sender_id',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => false,
						));
					$tb->text('contact', array (
						  'name' => 'contact',
						  'type' => Field::TEXT,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('url', array (
						  'name' => 'url',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('username', array (
						  'name' => 'username',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->string('password', array (
						  'name' => 'password',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('sms_template', function (SchemaBuilder $tb) {
					$tb->string('title', array (
						  'name' => 'title',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('message', array (
						  'name' => 'message',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('social', function (SchemaBuilder $tb) {
					$tb->string('handle', array (
						  'name' => 'handle',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->unique('handle');

				});
			},
			
			function(){
				return Schema::create('supplier', function (SchemaBuilder $tb) {
					$tb->string('company', array (
						  'name' => 'company',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('email', array (
						  'name' => 'email',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->string('phone', array (
						  'name' => 'phone',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->string('address', array (
						  'name' => 'address',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('note', array (
						  'name' => 'note',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('unit', function (SchemaBuilder $tb) {
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('code', array (
						  'name' => 'code',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->string('type', array (
						  'name' => 'type',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('note', array (
						  'name' => 'note',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));

				});
			},
			
			function(){
				return Schema::create('staff', function (SchemaBuilder $tb) {
					$tb->string('firstname', array (
						  'name' => 'firstname',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('lastname', array (
						  'name' => 'lastname',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('othername', array (
						  'name' => 'othername',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('email', array (
						  'name' => 'email',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => false,
						));
					$tb->string('phone', array (
						  'name' => 'phone',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->string('dob', array (
						  'name' => 'dob',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->enum('gender', array (
						  'name' => 'gender',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => 'male',
						    1 => 'female',
						  ),
						  'null' => false,
						));
					$tb->string('marital_status', array (
						  'name' => 'marital_status',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('religion', array (
						  'name' => 'religion',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('photo', array (
						  'name' => 'photo',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->string('address', array (
						  'name' => 'address',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('city', array (
						  'name' => 'city',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('state', array (
						  'name' => 'state',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('country', array (
						  'name' => 'country',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('staff_num', array (
						  'name' => 'staff_num',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('join_date', array (
						  'name' => 'join_date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('qualification', array (
						  'name' => 'qualification',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('experience', array (
						  'name' => 'experience',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->integer('role_id', array (
						  'name' => 'role_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->integer('designation_id', array (
						  'name' => 'designation_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => true,
						));
					$tb->integer('department_id', array (
						  'name' => 'department_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => true,
						));
					$tb->string('appointment', array (
						  'name' => 'appointment',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->integer('salary_id', array (
						  'name' => 'salary_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => true,
						));
					$tb->string('alt_contact', array (
						  'name' => 'alt_contact',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->unique('email');
					$tb->unique('phone');
					$tb->index('role_id');
					$tb->index('designation_id');
					$tb->index('department_id');
					$tb->index('salary_id');
					$tb->foreignKey('role_id', 'role', 'id', 'CASCADE');
					$tb->foreignKey('designation_id', 'designation', 'id', 'SET NULL');
					$tb->foreignKey('department_id', 'department', 'id', 'SET NULL');
					$tb->foreignKey('salary_id', 'salary', 'id', 'SET NULL');

				});
			},
			
			function(){
				return Schema::create('account', function (SchemaBuilder $tb) {
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->string('number', array (
						  'name' => 'number',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('bank', array (
						  'name' => 'bank',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('branch', array (
						  'name' => 'branch',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->integer('staff_id', array (
						  'name' => 'staff_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('staff_id');
					$tb->foreignKey('staff_id', 'staff', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('event', function (SchemaBuilder $tb) {
					$tb->integer('type', array (
						  'name' => 'type',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->string('title', array (
						  'name' => 'title',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('description', array (
						  'name' => 'description',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('venue', array (
						  'name' => 'venue',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('start_date', array (
						  'name' => 'start_date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('close_date', array (
						  'name' => 'close_date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('image', array (
						  'name' => 'image',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('type');
					$tb->foreignKey('type', 'event_type', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('event_invitee', function (SchemaBuilder $tb) {
					$tb->integer('event_id', array (
						  'name' => 'event_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->integer('invitee', array (
						  'name' => 'invitee',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('event_id');
					$tb->index('invitee');
					$tb->foreignKey('event_id', 'event', 'id', 'CASCADE');
					$tb->foreignKey('invitee', 'role', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('expense', function (SchemaBuilder $tb) {
					$tb->integer('expense_head', array (
						  'name' => 'expense_head',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->string('title', array (
						  'name' => 'title',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => false,
						));
					$tb->string('ref_num', array (
						  'name' => 'ref_num',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('amount', array (
						  'name' => 'amount',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->string('attachment', array (
						  'name' => 'attachment',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('date', array (
						  'name' => 'date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('paid_via', array (
						  'name' => 'paid_via',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('description', array (
						  'name' => 'description',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('expense_head');
					$tb->foreignKey('expense_head', 'expense_head', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('income', function (SchemaBuilder $tb) {
					$tb->integer('income_head', array (
						  'name' => 'income_head',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->string('title', array (
						  'name' => 'title',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => false,
						));
					$tb->string('ref_num', array (
						  'name' => 'ref_num',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('amount', array (
						  'name' => 'amount',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->string('attachment', array (
						  'name' => 'attachment',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('date', array (
						  'name' => 'date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('received_via', array (
						  'name' => 'received_via',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('description', array (
						  'name' => 'description',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('income_head');
					$tb->foreignKey('income_head', 'income_head', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('store', function (SchemaBuilder $tb) {
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('code', array (
						  'name' => 'code',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('note', array (
						  'name' => 'note',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('address', array (
						  'name' => 'address',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->integer('manager', array (
						  'name' => 'manager',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('manager');
					$tb->foreignKey('manager', 'staff', 'id', 'SET NULL');

				});
			},
			
			function(){
				return Schema::create('product', function (SchemaBuilder $tb) {
					$tb->integer('category_id', array (
						  'name' => 'category_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('code', array (
						  'name' => 'code',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('size', array (
						  'name' => 'size',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->integer('unit_id', array (
						  'name' => 'unit_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => true,
						));
					$tb->string('pack', array (
						  'name' => 'pack',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->integer('type', array (
						  'name' => 'type',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => true,
						));
					$tb->string('note', array (
						  'name' => 'note',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('image', array (
						  'name' => 'image',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->string('price', array (
						  'name' => 'price',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->integer('brand_id', array (
						  'name' => 'brand_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('category_id');
					$tb->index('unit_id');
					$tb->index('type');
					$tb->index('brand_id');
					$tb->foreignKey('category_id', 'category', 'id', 'CASCADE');
					$tb->foreignKey('unit_id', 'unit', 'id', 'SET NULL');
					$tb->foreignKey('type', 'product_type', 'id', 'SET NULL');
					$tb->foreignKey('brand_id', 'brand', 'id', 'SET NULL');

				});
			},
			
			function(){
				return Schema::create('inventory', function (SchemaBuilder $tb) {
					$tb->integer('store_id', array (
						  'name' => 'store_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->integer('product_id', array (
						  'name' => 'product_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->string('quantity', array (
						  'name' => 'quantity',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->enum('symbol', array (
						  'name' => 'symbol',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => '-',
						    1 => '+',
						  ),
						  'null' => false,
						  'default' => '+',
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('store_id');
					$tb->index('product_id');
					$tb->foreignKey('store_id', 'store', 'id', 'CASCADE');
					$tb->foreignKey('product_id', 'product', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('invoice', function (SchemaBuilder $tb) {
					$tb->integer('customer_id', array (
						  'name' => 'customer_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => true,
						));
					$tb->integer('issuer', array (
						  'name' => 'issuer',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->string('date', array (
						  'name' => 'date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('amount', array (
						  'name' => 'amount',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->string('paid', array (
						  'name' => 'paid',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						  'default' => '0',
						));
					$tb->string('balance', array (
						  'name' => 'balance',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						  'default' => '0',
						));
					$tb->string('discount', array (
						  'name' => 'discount',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('bill_code', array (
						  'name' => 'bill_code',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('customer_id');
					$tb->index('issuer');
					$tb->unique('bill_code');
					$tb->foreignKey('customer_id', 'customer', 'id', 'SET NULL');
					$tb->foreignKey('issuer', 'staff', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('leave', function (SchemaBuilder $tb) {
					$tb->integer('staff_id', array (
						  'name' => 'staff_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->integer('leave_type', array (
						  'name' => 'leave_type',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->string('from', array (
						  'name' => 'from',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->string('to', array (
						  'name' => 'to',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->enum('status', array (
						  'name' => 'status',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => 'pending',
						    1 => 'approved',
						    2 => 'declined',
						  ),
						  'null' => false,
						  'default' => 'pending',
						));
					$tb->string('reason', array (
						  'name' => 'reason',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('remark', array (
						  'name' => 'remark',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('file', array (
						  'name' => 'file',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->integer('approved_by', array (
						  'name' => 'approved_by',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('staff_id');
					$tb->index('leave_type');
					$tb->index('approved_by');
					$tb->foreignKey('staff_id', 'staff', 'id', 'CASCADE');
					$tb->foreignKey('leave_type', 'leave_type', 'id', 'CASCADE');
					$tb->foreignKey('approved_by', 'staff', 'id', 'SET NULL');

				});
			},
			
			function(){
				return Schema::create('material', function (SchemaBuilder $tb) {
					$tb->string('title', array (
						  'name' => 'title',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => false,
						));
					$tb->integer('author', array (
						  'name' => 'author',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->integer('type', array (
						  'name' => 'type',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->string('document', array (
						  'name' => 'document',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->string('doctype', array (
						  'name' => 'doctype',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('remark', array (
						  'name' => 'remark',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('author');
					$tb->index('type');
					$tb->foreignKey('author', 'staff', 'id', 'CASCADE');
					$tb->foreignKey('type', 'material_type', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('notice_audience', function (SchemaBuilder $tb) {
					$tb->integer('notice_id', array (
						  'name' => 'notice_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->integer('audience', array (
						  'name' => 'audience',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('notice_id');
					$tb->index('audience');
					$tb->foreignKey('notice_id', 'notice', 'id', 'CASCADE');
					$tb->foreignKey('audience', 'role', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('payment', function (SchemaBuilder $tb) {
					$tb->integer('invoice_id', array (
						  'name' => 'invoice_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->string('date', array (
						  'name' => 'date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('amount', array (
						  'name' => 'amount',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->integer('payment_mode', array (
						  'name' => 'payment_mode',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('invoice_id');
					$tb->index('payment_mode');
					$tb->foreignKey('invoice_id', 'invoice', 'id', 'CASCADE');
					$tb->foreignKey('payment_mode', 'payment_mode', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('payslip', function (SchemaBuilder $tb) {
					$tb->integer('staff_id', array (
						  'name' => 'staff_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->string('basic_salary', array (
						  'name' => 'basic_salary',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->string('total_allowance', array (
						  'name' => 'total_allowance',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('total_deduction', array (
						  'name' => 'total_deduction',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('tax', array (
						  'name' => 'tax',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('net_salary', array (
						  'name' => 'net_salary',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('bill_num', array (
						  'name' => 'bill_num',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('month', array (
						  'name' => 'month',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('year', array (
						  'name' => 'year',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('remark', array (
						  'name' => 'remark',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('payment_date', array (
						  'name' => 'payment_date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->integer('payment_mode', array (
						  'name' => 'payment_mode',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->enum('status', array (
						  'name' => 'status',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => 'pending',
						    1 => 'paid',
						  ),
						  'null' => false,
						  'default' => 'pending',
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('staff_id');
					$tb->index('payment_mode');
					$tb->foreignKey('staff_id', 'staff', 'id', 'CASCADE');
					$tb->foreignKey('payment_mode', 'payment_mode', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('payslip_detail', function (SchemaBuilder $tb) {
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('amount', array (
						  'name' => 'amount',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('type', array (
						  'name' => 'type',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->integer('payslip_id', array (
						  'name' => 'payslip_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('payslip_id');
					$tb->foreignKey('payslip_id', 'payslip', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('permission', function (SchemaBuilder $tb) {
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('slug', array (
						  'name' => 'slug',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->integer('module_id', array (
						  'name' => 'module_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => true,
						));
					$tb->enum('enable_create', array (
						  'name' => 'enable_create',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => '0',
						    1 => '1',
						  ),
						  'null' => true,
						  'default' => '0',
						));
					$tb->enum('enable_read', array (
						  'name' => 'enable_read',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => '0',
						    1 => '1',
						  ),
						  'null' => true,
						  'default' => '0',
						));
					$tb->enum('enable_update', array (
						  'name' => 'enable_update',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => '0',
						    1 => '1',
						  ),
						  'null' => true,
						  'default' => '0',
						));
					$tb->enum('enable_delete', array (
						  'name' => 'enable_delete',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => '0',
						    1 => '1',
						  ),
						  'null' => true,
						  'default' => '0',
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('module_id');
					$tb->foreignKey('module_id', 'module', 'id', 'SET NULL');

				});
			},
			
			function(){
				return Schema::create('purchase', function (SchemaBuilder $tb) {
					$tb->integer('product_id', array (
						  'name' => 'product_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->integer('supplier_id', array (
						  'name' => 'supplier_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => true,
						));
					$tb->string('quantity', array (
						  'name' => 'quantity',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->string('purchase_price', array (
						  'name' => 'purchase_price',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->string('selling_price', array (
						  'name' => 'selling_price',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('profit_margin', array (
						  'name' => 'profit_margin',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('profit_percentage', array (
						  'name' => 'profit_percentage',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('purchase_code', array (
						  'name' => 'purchase_code',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('remark', array (
						  'name' => 'remark',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('date', array (
						  'name' => 'date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->enum('price_update', array (
						  'name' => 'price_update',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => 'drop',
						    1 => 'normal',
						    2 => 'top',
						  ),
						  'null' => true,
						  'default' => 'normal',
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('product_id');
					$tb->index('supplier_id');
					$tb->foreignKey('product_id', 'product', 'id', 'CASCADE');
					$tb->foreignKey('supplier_id', 'supplier', 'id', 'SET NULL');

				});
			},
			
			function(){
				return Schema::create('role_permission', function (SchemaBuilder $tb) {
					$tb->integer('role_id', array (
						  'name' => 'role_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->integer('permission_id', array (
						  'name' => 'permission_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->enum('can_create', array (
						  'name' => 'can_create',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => '0',
						    1 => '1',
						  ),
						  'null' => true,
						  'default' => '0',
						));
					$tb->enum('can_read', array (
						  'name' => 'can_read',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => '0',
						    1 => '1',
						  ),
						  'null' => true,
						  'default' => '0',
						));
					$tb->enum('can_update', array (
						  'name' => 'can_update',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => '0',
						    1 => '1',
						  ),
						  'null' => true,
						  'default' => '0',
						));
					$tb->enum('can_delete', array (
						  'name' => 'can_delete',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => '0',
						    1 => '1',
						  ),
						  'null' => true,
						  'default' => '0',
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('role_id');
					$tb->index('permission_id');
					$tb->foreignKey('role_id', 'role', 'id', 'CASCADE');
					$tb->foreignKey('permission_id', 'permission', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('salary_detail', function (SchemaBuilder $tb) {
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->string('amount', array (
						  'name' => 'amount',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->enum('type', array (
						  'name' => 'type',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => 'allowance',
						    1 => 'deduction',
						  ),
						  'null' => false,
						));
					$tb->integer('salary_id', array (
						  'name' => 'salary_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('salary_id');
					$tb->foreignKey('salary_id', 'salary', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('sale', function (SchemaBuilder $tb) {
					$tb->integer('product_id', array (
						  'name' => 'product_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->integer('store_id', array (
						  'name' => 'store_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->string('quantity', array (
						  'name' => 'quantity',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->string('unit_price', array (
						  'name' => 'unit_price',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('total_price', array (
						  'name' => 'total_price',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->integer('invoice_id', array (
						  'name' => 'invoice_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->string('remark', array (
						  'name' => 'remark',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('sold_date', array (
						  'name' => 'sold_date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('return_date', array (
						  'name' => 'return_date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('product_id');
					$tb->index('store_id');
					$tb->index('invoice_id');
					$tb->foreignKey('product_id', 'product', 'id', 'CASCADE');
					$tb->foreignKey('store_id', 'store', 'id', 'CASCADE');
					$tb->foreignKey('invoice_id', 'invoice', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('social_number', function (SchemaBuilder $tb) {
					$tb->enum('type', array (
						  'name' => 'type',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => 'national id',
						    1 => 'drivers licence',
						    2 => 'voters card',
						    3 => 'international passport',
						  ),
						  'null' => false,
						));
					$tb->string('number', array (
						  'name' => 'number',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => false,
						));
					$tb->integer('staff_id', array (
						  'name' => 'staff_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('staff_id');
					$tb->foreignKey('staff_id', 'staff', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('staff_attendance', function (SchemaBuilder $tb) {
					$tb->enum('status', array (
						  'name' => 'status',
						  'type' => Field::ENUM,
						  'size' => 
						  array (
						    0 => 'present',
						    1 => 'holiday',
						    2 => 'late',
						    3 => 'absent',
						    4 => 'vacation',
						    5 => 'null',
						  ),
						  'null' => true,
						  'default' => 'null',
						));
					$tb->string('date', array (
						  'name' => 'date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->string('remark', array (
						  'name' => 'remark',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->integer('staff_id', array (
						  'name' => 'staff_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('staff_id');
					$tb->foreignKey('staff_id', 'staff', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('staff_document', function (SchemaBuilder $tb) {
					$tb->string('name', array (
						  'name' => 'name',
						  'type' => Field::CHAR,
						  'size' => 50,
						  'null' => true,
						));
					$tb->string('type', array (
						  'name' => 'type',
						  'type' => Field::CHAR,
						  'size' => 20,
						  'null' => true,
						));
					$tb->string('path', array (
						  'name' => 'path',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->string('note', array (
						  'name' => 'note',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->integer('staff_id', array (
						  'name' => 'staff_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('staff_id');
					$tb->foreignKey('staff_id', 'staff', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('staff_social', function (SchemaBuilder $tb) {
					$tb->string('link', array (
						  'name' => 'link',
						  'type' => Field::CHAR,
						  'size' => 100,
						  'null' => true,
						));
					$tb->integer('staff_id', array (
						  'name' => 'staff_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->integer('social_id', array (
						  'name' => 'social_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('staff_id');
					$tb->index('social_id');
					$tb->foreignKey('staff_id', 'staff', 'id', 'CASCADE');
					$tb->foreignKey('social_id', 'social', 'id', 'CASCADE');

				});
			},
			
			function(){
				return Schema::create('stock', function (SchemaBuilder $tb) {
					$tb->integer('store_id', array (
						  'name' => 'store_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->integer('product_id', array (
						  'name' => 'product_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => false,
						));
					$tb->integer('purchase_id', array (
						  'name' => 'purchase_id',
						  'type' => 'bigint',
						  'size' => 20,
						  'unsigned' => true,
						  'null' => true,
						));
					$tb->string('quantity', array (
						  'name' => 'quantity',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => false,
						));
					$tb->string('batch_code', array (
						  'name' => 'batch_code',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('remark', array (
						  'name' => 'remark',
						  'type' => Field::CHAR,
						  'size' => 255,
						  'null' => true,
						));
					$tb->string('date', array (
						  'name' => 'date',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->string('expiry', array (
						  'name' => 'expiry',
						  'type' => Field::CHAR,
						  'size' => 25,
						  'null' => true,
						));
					$tb->datetime('created_at', array (
						  'name' => 'created_at',
						  'type' => Field::DATETIME,
						  'null' => false,
						));
					$tb->datetime('updated_at', array (
						  'name' => 'updated_at',
						  'type' => Field::DATETIME,
						  'null' => true,
						));
					$tb->index('store_id');
					$tb->index('product_id');
					$tb->index('purchase_id');
					$tb->foreignKey('store_id', 'store', 'id', 'CASCADE');
					$tb->foreignKey('product_id', 'product', 'id', 'CASCADE');
					$tb->foreignKey('purchase_id', 'purchase', 'id', 'SET NULL');

				});
			},
		];

		$this->reverse = [
			
			function(){
				return Schema::dropIfExists('stock');
			},
			
			function(){
				return Schema::dropIfExists('staff_social');
			},
			
			function(){
				return Schema::dropIfExists('staff_document');
			},
			
			function(){
				return Schema::dropIfExists('staff_attendance');
			},
			
			function(){
				return Schema::dropIfExists('social_number');
			},
			
			function(){
				return Schema::dropIfExists('sale');
			},
			
			function(){
				return Schema::dropIfExists('salary_detail');
			},
			
			function(){
				return Schema::dropIfExists('role_permission');
			},
			
			function(){
				return Schema::dropIfExists('purchase');
			},
			
			function(){
				return Schema::dropIfExists('permission');
			},
			
			function(){
				return Schema::dropIfExists('payslip_detail');
			},
			
			function(){
				return Schema::dropIfExists('payslip');
			},
			
			function(){
				return Schema::dropIfExists('payment');
			},
			
			function(){
				return Schema::dropIfExists('notice_audience');
			},
			
			function(){
				return Schema::dropIfExists('material');
			},
			
			function(){
				return Schema::dropIfExists('leave');
			},
			
			function(){
				return Schema::dropIfExists('invoice');
			},
			
			function(){
				return Schema::dropIfExists('inventory');
			},
			
			function(){
				return Schema::dropIfExists('product');
			},
			
			function(){
				return Schema::dropIfExists('store');
			},
			
			function(){
				return Schema::dropIfExists('income');
			},
			
			function(){
				return Schema::dropIfExists('expense');
			},
			
			function(){
				return Schema::dropIfExists('event_invitee');
			},
			
			function(){
				return Schema::dropIfExists('event');
			},
			
			function(){
				return Schema::dropIfExists('account');
			},
			
			function(){
				return Schema::dropIfExists('staff');
			},
			
			function(){
				return Schema::dropIfExists('unit');
			},
			
			function(){
				return Schema::dropIfExists('supplier');
			},
			
			function(){
				return Schema::dropIfExists('social');
			},
			
			function(){
				return Schema::dropIfExists('sms_template');
			},
			
			function(){
				return Schema::dropIfExists('sms_config');
			},
			
			function(){
				return Schema::dropIfExists('salary');
			},
			
			function(){
				return Schema::dropIfExists('role');
			},
			
			function(){
				return Schema::dropIfExists('product_type');
			},
			
			function(){
				return Schema::dropIfExists('payment_mode');
			},
			
			function(){
				return Schema::dropIfExists('notice');
			},
			
			function(){
				return Schema::dropIfExists('module');
			},
			
			function(){
				return Schema::dropIfExists('material_type');
			},
			
			function(){
				return Schema::dropIfExists('leave_type');
			},
			
			function(){
				return Schema::dropIfExists('income_head');
			},
			
			function(){
				return Schema::dropIfExists('holiday');
			},
			
			function(){
				return Schema::dropIfExists('expense_head');
			},
			
			function(){
				return Schema::dropIfExists('event_type');
			},
			
			function(){
				return Schema::dropIfExists('email_template');
			},
			
			function(){
				return Schema::dropIfExists('email_config');
			},
			
			function(){
				return Schema::dropIfExists('designation');
			},
			
			function(){
				return Schema::dropIfExists('department');
			},
			
			function(){
				return Schema::dropIfExists('customer');
			},
			
			function(){
				return Schema::dropIfExists('category');
			},
			
			function(){
				return Schema::dropIfExists('bulk_send');
			},
			
			function(){
				return Schema::dropIfExists('bulk_message');
			},
			
			function(){
				return Schema::dropIfExists('brand');
			},
		];
	}
}