<?php 
namespace App\Controllers;

use Tiyyick\Router\Controller;
use Tiyyick\Http\Request;

use App\Models\Staff;
use App\Models\Department;
use App\Models\Designation;
use App\Models\Role;
use App\Forms\LoginForm;

/**
 * 
 */
class UserController extends Controller
{
	public function login(Request $request)
	{
		if (is_auth()) {
			return redirect(route('admin.index'));
		}
		
		if ($request->method === 'POST') {
			$loginform = new LoginForm($request);

			if ($loginform->isValid()) {
				$user = Staff::query()->filter(['username' => $request->username, 'or', 'email' => $request->username, 'or', 'phone' => $request->username])->one();

				if ($user && password_verify($request->password, $user->password)) {
					$rm = isset($_POST['remember_me']) ? 1 : 0;
					login_user($user, $rm);

					return redirect(route('admin.index'));
				} else {
					flash('danger', 'Invalid email or password'); 
				}
			} else {
				flash('danger', 'Invalid email or password');
			}
		} else {
			$loginform = new LoginForm();
		}

		return render('admin/user/login-user', ['loginform' => $loginform]);
	}

	public function logout()
	{
		logout_user();
		return redirect(route('user.login'));
	}

}
