<?php 
namespace App\Controllers;

use Tiyyick\Router\Controller;
use Tiyyick\Http\Request;

use App\Models\Role;
use App\Models\Permission;
use App\Models\RolePermission;
use App\Models\Module;
use App\Models\PaymentMode;
use App\Models\Inventory;
use App\Models\Product;
use App\Models\Store;
use App\Models\Company;

/**
 * 
 */
class SettingsController extends Controller
{
	public function role()
	{
		$roles = Role::query()->all();

		return render('admin/setting/role', ['roles' => $roles]);
	}

	public function createRole(Request $request)
	{
		$valid = validate($request, [
			'name' => ['required' => true],
		]);

		if ($valid->isValid()) {
			Role::query()->create([
				'name' => $request->name,
				'slug' => slugify($request->name, '-', false),
			]);

		    return json_response(['ok' => true, 'msg' => "Role created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function updateRole(Request $request, $id)
	{
		$valid = validate($request, [
			'name' => ['required' => true],
		]);

		if ($valid->isValid()) {
			$section = Role::query()->filter(['id' => $id])->one(); 
			$section->name = $request->name;
			$section->slug = slugify($request->name, '-', false);
			$section->save();

		    return json_response(['ok' => true, 'msg' => "Role updated successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deleteRole(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			Role::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Role deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function paymentMode(Request $request)
	{
		if ($request->hasParam('_id')) {
			return json_response(['row' => PaymentMode::query()->get($request->_id)]);
		}

		$payment_modes = PaymentMode::query()->all();

		return render('admin/setting/payment-mode', ['payment_modes' => $payment_modes]);
	}

	public function createPaymentMode(Request $request)
	{
		$valid = validate($request, [
			'via' => ['required' => true],
		]);

		if ($valid->isValid()) {
			if ($request->hasParam('_id')) {
				PaymentMode::query()->filter(['id' => $request->_id])->update($request->body()); 

		    	return json_response(['ok' => true, 'msg' => "Payment mode updated successfully"]);
			}

			PaymentMode::query()->create($request->body());

		    return json_response(['ok' => true, 'msg' => "Payment mode created successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function deletePaymentMode(Request $request, $id)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			PaymentMode::query()->filter(['id' => $id])->delete();

			return json_response(['ok' => true, 'msg' => "Payment mode deleted successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

	public function storeInventory()
	{
		$stores = Store::query()->all();

		return render('admin/setting/stores', ['stores' => $stores]);
	}

	public function createStoreInventory($id)
	{
		$store = Store::query()->get($id);
		$products = Product::query()->all();

		foreach ($products as $product) {
			if (! Inventory::query()->filter(['store' => $store, 'and', 'product' => $product])->exists()) {
				Inventory::query()->create(['store' => $store, 'product' => $product]); // code...
			}
		}
		
	    return json_response(['ok' => true, 'msg' => "Product store inventory created successfully"]);
	}

	public function companyIndex()
	{
		$data['company'] = Company::query()->get(1);

		return render('admin/setting/company', $data);
	}

	public function updateCompany(Request $request)
	{
		$form = validate($request, [
            "name" => ["required" => true, "maxlen" => 50],
            "email" => ["required" => true, "maxlen" => 50],
            "phone" => ["required" => true,],
        ]);

		if ($form->isValid()) {
			$companyExist = Company::query()->filter(['id' => 1])->exists();

			if ($companyExist) {
				$company = Company::query()->filter(['id' => 1])->one();
				$company->update($request->body());

				if ($request->hasFile('logo')) {
					if (file_exists(storage_path("company/$company->logo"))) {
		                unlink(storage_path("company/$company->logo"));
		            } 
					
					$file = $request->getFile('logo');
					$company->logo = $file->store('company', bin2hex(random_bytes(8)) . '.png');
				}
			} else {
				$company = new Company($request->body());

				if ($request->hasFile('logo')) {
					$file = $request->getFile('logo');
					$company->logo = $file->store('company', bin2hex(random_bytes(8)) . '.png');
				} 
			}
			
			$company = $company->save();

			$data['ok']  = true; 
			$data['msg'] = 'General settings updated successfully';
		} else {
			$data['error'] = $form->getErrors();
		}	

		return json_response($data);
	}

	public function rolePermission($role)
	{
		$data['role'] = Role::query()->get($role);
		$data['permissions'] = Permission::query()->order_by('module_id ASC')->all();

		return render('admin/setting/role-permission', $data);
	}

	public function createRolePermission(Request $request)
	{
		$valid = validate($request);

		if ($valid->isValid()) {
			foreach ($request->input('rows') as $row) {
				$rolePerm = RolePermission::query()->filter([
					'role' => $row['role'], 'and',
					'permission' => $row['permission'],
				])->one();

				if ($rolePerm) {
					$rolePerm->update($row);
					$rolePerm->save();
				} else {
					RolePermission::query()->create($row);
				}
			}

		    return json_response([ 'ok' => true, 'msg' => "Role permissions saved successfully"]);
		} else {
			return json_response(['error' => $valid->getErrors()]);
		}
	}

}
